/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.netty.NettyTlsUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http3.Http3;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.codec.quic.QuicSslContextBuilder;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

public abstract class AbstractServerSslBuilder
extends SslBuilder<SslContext>
implements ServerSslBuilder {
    private final HttpServerConfiguration httpServerConfiguration;

    public AbstractServerSslBuilder(ResourceResolver resourceResolver, HttpServerConfiguration httpServerConfiguration) {
        super(resourceResolver);
        this.httpServerConfiguration = httpServerConfiguration;
    }

    @Override
    public final Optional<SslContext> build() {
        return this.build((SslConfiguration)this.getSslConfiguration());
    }

    public final Optional<SslContext> build(SslConfiguration ssl) {
        HttpVersion httpVersion = this.httpServerConfiguration.getHttpVersion();
        return this.build(ssl, httpVersion);
    }

    public final Optional<SslContext> build(SslConfiguration ssl, HttpVersion httpVersion) {
        SslContextBuilder sslBuilder = SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory(ssl)).trustManager(this.getTrustManagerFactory(ssl));
        AbstractServerSslBuilder.setupSslBuilder(sslBuilder, ssl, httpVersion);
        this.processBuilder(sslBuilder, ssl, httpVersion);
        try {
            return Optional.of(sslBuilder.build());
        }
        catch (SSLException ex) {
            throw new SslConfigurationException("An error occurred while setting up SSL", (Throwable)ex);
        }
    }

    protected void processBuilder(@NonNull SslContextBuilder sslBuilder, @NonNull SslConfiguration ssl, @NonNull HttpVersion httpVersion) {
    }

    private static void setupSslBuilder(SslContextBuilder sslBuilder, SslConfiguration ssl, HttpVersion httpVersion) {
        sslBuilder.sslProvider(NettyTlsUtils.sslProvider((SslConfiguration)ssl));
        Optional protocols = ssl.getProtocols();
        if (protocols.isPresent()) {
            sslBuilder.protocols((String[])protocols.get());
        }
        boolean isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        Optional ciphers = ssl.getCiphers();
        if (ciphers.isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((String[])ciphers.get()));
        } else if (isHttp2) {
            sslBuilder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        }
        Optional clientAuthentication = ssl.getClientAuthentication();
        if (clientAuthentication.isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)clientAuthentication.get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        if (isHttp2) {
            sslBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        }
    }

    @Override
    public final Optional<QuicSslContext> buildQuic() {
        ServerSslConfiguration ssl = this.getSslConfiguration();
        QuicSslContextBuilder sslBuilder = QuicSslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory((SslConfiguration)ssl), (String)ssl.getKeyStore().getPassword().orElse(null)).trustManager(this.getTrustManagerFactory((SslConfiguration)ssl)).applicationProtocols(Http3.supportedApplicationProtocols());
        Optional clientAuthentication = ssl.getClientAuthentication();
        if (clientAuthentication.isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)clientAuthentication.get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        return Optional.of(sslBuilder.build());
    }

    protected KeyManagerFactory getKeyManagerFactory(SslConfiguration ssl) {
        try {
            return NettyTlsUtils.storeToFactory((SslConfiguration)ssl, (KeyStore)this.getKeyStore(ssl).orElse(null));
        }
        catch (Exception ex) {
            throw new SslConfigurationException((Throwable)ex);
        }
    }
}

