/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.cors;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.CorsUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import io.micronaut.http.server.util.HttpHostResolver;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Test;

public class CorsDisabledByDefaultTest {
    private static final String SPECNAME = "CorsDisabledByDefaultTest";

    @Test
    void corsDisabledByDefault() throws IOException {
        TestScenario.asserts(SPECNAME, CorsDisabledByDefaultTest.createRequest("https://foo.com"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(CorsUtils::assertCorsHeadersNotPresent).build()));
    }

    static HttpRequest<?> createRequest(String origin) {
        return HttpRequest.POST((String)"/refresh", Collections.emptyMap()).header((CharSequence)"Content-Type", (CharSequence)"application/json").header((CharSequence)"Origin", (CharSequence)origin).header((CharSequence)"Accept-Encoding", (CharSequence)"gzip, deflate").header((CharSequence)"Connection", (CharSequence)"keep-alive").header((CharSequence)"Accept", (CharSequence)"*/*").header((CharSequence)"User-Agent", (CharSequence)"Mozilla / 5.0 (Macintosh; Intel Mac OS X 10_15_7)AppleWebKit / 605.1 .15 (KHTML, like Gecko)Version / 16.1 Safari / 605.1 .15").header((CharSequence)"Referer", (CharSequence)origin).header((CharSequence)"Accept-Language", (CharSequence)"en - GB, en");
    }

    @Requires(property="spec.name", value="CorsDisabledByDefaultTest")
    @Replaces(value=HttpHostResolver.class)
    @Singleton
    static class HttpHostResolverReplacement
    implements HttpHostResolver {
        HttpHostResolverReplacement() {
        }

        public String resolve(@Nullable HttpRequest request) {
            return "https://micronautexample.com";
        }
    }

    @Requires(property="spec.name", value="CorsDisabledByDefaultTest")
    @Controller
    static class RefreshController {
        RefreshController() {
        }

        @Post(value="/refresh")
        @Status(value=HttpStatus.OK)
        void refresh() {
        }
    }
}

