/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.cors;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.CorsAssertion;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.RequestSupplier;
import io.micronaut.http.server.tck.ServerUnderTest;
import io.micronaut.http.server.tck.TestScenario;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CorsSimpleRequestTest {
    private static final String SPECNAME = "CorsSimpleRequestTest";
    private static final String PROPERTY_MICRONAUT_SERVER_CORS_ENABLED = "micronaut.server.cors.enabled";
    private static final String PROPERTY_MICRONAUT_SERVER_CORS_LOCALHOST_PASS_THROUGH = "micronaut.server.cors.localhost-pass-through";

    @Test
    void corsSimpleRequestNotAllowedForLocalhostAndAny() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), CorsSimpleRequestTest.createRequest("https://foo.com"), CorsSimpleRequestTest::isForbidden);
    }

    @Test
    void corsSimpleRequestAllowedForLocalhostAndAnyWhenSpecificallyTurnedOff() throws IOException {
        TestScenario.asserts(SPECNAME, (Map<String, Object>)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true", PROPERTY_MICRONAUT_SERVER_CORS_LOCALHOST_PASS_THROUGH, "true"}), CorsSimpleRequestTest.createRequest("https://foo.com"), CorsSimpleRequestTest::isSuccessful);
    }

    @Test
    void corsSimpleRequestNotAllowedFor127AndAny() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), this.createRequestFor("127.0.0.1", "https://foo.com"), CorsSimpleRequestTest::isForbidden);
    }

    @Test
    void corsSimpleRequestAllowedForLocalhostAndOriginLocalhost() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), CorsSimpleRequestTest.createRequest("http://localhost:8000"), CorsSimpleRequestTest::isSuccessful);
    }

    @Test
    void corsSimpleRequestAllowedForLocalhostAnd127Origin() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), this.createRequestFor("localhost", "http://127.0.0.1:8000"), CorsSimpleRequestTest::isSuccessful);
    }

    @Test
    void corsSimpleRequestFailsForLocalhostAndSpoofed127Origin() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), this.createRequestFor("localhost", "http://127.0.0.1.hac0r.com:8000"), CorsSimpleRequestTest::isForbidden);
    }

    @Test
    void corsSimpleRequestAllowedFor127RequestAndLocalhostOrigin() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), this.createRequestFor("127.0.0.1", "http://localhost:8000"), CorsSimpleRequestTest::isSuccessful);
    }

    @Test
    void corsSimpleRequestForLocalhostCanBeAllowedViaConfiguration() throws IOException {
        TestScenario.asserts(SPECNAME, (Map<String, Object>)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true", "micronaut.server.cors.configurations.foo.allowed-origins", Collections.singletonList("https://foo.com")}), CorsSimpleRequestTest.createRequest("https://foo.com"), CorsSimpleRequestTest::isSuccessfulCorsAssertion);
    }

    @Test
    void corsSimpleRequestForLocalhostCanBeAllowedViaRegexConfiguration() throws IOException {
        TestScenario.asserts(SPECNAME, (Map<String, Object>)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true", "micronaut.server.cors.configurations.foo.allowed-origins-regex", Collections.singletonList("^http(|s):\\/\\/foo\\.com$")}), CorsSimpleRequestTest.createRequest("https://foo.com"), CorsSimpleRequestTest::isSuccessfulCorsAssertion);
    }

    @Test
    void corsSimpleRequestForLocalhostForbiddenViaRegexConfiguration() throws IOException {
        TestScenario.asserts(SPECNAME, (Map<String, Object>)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true", "micronaut.server.cors.configurations.foo.allowed-origins-regex", Collections.singletonList("^http(|s):\\/\\/foo\\.com$")}), CorsSimpleRequestTest.createRequest("https://bar.com"), CorsSimpleRequestTest::isForbidden);
    }

    private RequestSupplier createRequestFor(String host, String origin) {
        return server -> CorsSimpleRequestTest.createRequest(server.getPort().map(p -> "http://" + host + ":" + p + "/refresh").orElseThrow(() -> new RuntimeException("Unknown port for " + server)), origin);
    }

    static void isForbidden(ServerUnderTest server, HttpRequest<?> request) {
        RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
        Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
        AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.FORBIDDEN).assertResponse(response -> Assertions.assertFalse((boolean)response.getHeaders().contains("Vary"))).build());
        Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
    }

    static void isSuccessful(ServerUnderTest server, HttpRequest<?> request) {
        RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
        Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
        AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).build());
        Assertions.assertEquals((int)1, (int)refreshCounter.getRefreshCount());
    }

    static void isSuccessfulCorsAssertion(ServerUnderTest server, HttpRequest<?> request) {
        RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
        Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
        AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> CorsAssertion.builder().vary("Origin").allowCredentials().allowOrigin("https://foo.com").build().validate((HttpResponse<?>)response)).build());
        Assertions.assertEquals((int)1, (int)refreshCounter.getRefreshCount());
    }

    static HttpRequest<?> createRequest(String origin) {
        return CorsSimpleRequestTest.createRequest("/refresh", origin);
    }

    static HttpRequest<?> createRequest(String uri, String origin) {
        return HttpRequest.POST((String)uri, (Object)MultipartBody.builder().addPart("force", "true").build()).header((CharSequence)"Content-Type", (CharSequence)"multipart/form-data; boundary=----WebKitFormBoundarywxiDZy8kMlSE59h1").header((CharSequence)"Origin", (CharSequence)origin).header((CharSequence)"Accept-Encoding", (CharSequence)"gzip, deflate").header((CharSequence)"Connection", (CharSequence)"keep-alive").header((CharSequence)"Accept", (CharSequence)"*/*").header((CharSequence)"User-Agent", (CharSequence)"Mozilla / 5.0 (Macintosh; Intel Mac OS X 10_15_7)AppleWebKit / 605.1 .15 (KHTML, like Gecko)Version / 16.1 Safari / 605.1 .15").header((CharSequence)"Referer", (CharSequence)origin).header((CharSequence)"Accept-Language", (CharSequence)"en - GB, en").header((CharSequence)"content-length", (CharSequence)"140");
    }

    @Requires(property="spec.name", value="CorsSimpleRequestTest")
    @Singleton
    static class RefreshCounter
    implements ApplicationEventListener<RefreshEvent> {
        private int refreshCount = 0;

        RefreshCounter() {
        }

        public void onApplicationEvent(RefreshEvent event) {
            ++this.refreshCount;
        }

        public int getRefreshCount() {
            return this.refreshCount;
        }
    }

    @Requires(property="spec.name", value="CorsSimpleRequestTest")
    @Controller
    static class RefreshController {
        @Inject
        ApplicationEventPublisher<RefreshEvent> refreshEventApplicationEventPublisher;

        RefreshController() {
        }

        @Consumes(value={"multipart/form-data"})
        @Post(value="/refresh")
        @Status(value=HttpStatus.OK)
        void refresh() {
            this.refreshEventApplicationEventPublisher.publishEvent((Object)new RefreshEvent());
        }
    }
}

