/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.cors;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleRequestWithCorsNotEnabledTest {
    private static final String SPECNAME = "SimpleRequestWithCorsNotEnabledTest";
    private static final String PROPERTY_MICRONAUT_SERVER_CORS_LOCALHOST_PASS_THROUGH = "micronaut.server.cors.localhost-pass-through";

    @Test
    void corsSimpleRequestNotAllowedForLocalhostAndAny() throws IOException {
        TestScenario.asserts(SPECNAME, SimpleRequestWithCorsNotEnabledTest.createRequest("https://sdelamo.github.io"), (server, request) -> {
            RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
            AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.FORBIDDEN).assertResponse(response -> Assertions.assertFalse((boolean)response.getHeaders().contains("Vary"))).build());
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
        });
    }

    @Test
    void corsSimpleRequestAllowedForLocalhostAndAnyWhenConfiguredToAllowIt() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_LOCALHOST_PASS_THROUGH, "true"), SimpleRequestWithCorsNotEnabledTest.createRequest("https://sdelamo.github.io"), (server, request) -> {
            RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
            AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).build());
            Assertions.assertEquals((int)1, (int)refreshCounter.getRefreshCount());
        });
    }

    @Test
    void corsSimpleRequestAllowedForLocalhostAndOriginLocalhost() throws IOException {
        TestScenario.asserts(SPECNAME, SimpleRequestWithCorsNotEnabledTest.createRequest("http://localhost:8000"), (server, request) -> {
            RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
            AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).build());
            Assertions.assertEquals((int)1, (int)refreshCounter.getRefreshCount());
        });
    }

    private static HttpRequest<?> createRequest(String origin) {
        return HttpRequest.POST((String)"/refresh", Collections.emptyMap()).header((CharSequence)"Accept", (CharSequence)"*/*").header((CharSequence)"Accept-Encoding", (CharSequence)"gzip, deflate, br").header((CharSequence)"Accept-Language", (CharSequence)"en-GB,en-US;q=0.9,en;q=0.8").header((CharSequence)"Connection", (CharSequence)"keep-alive").header((CharSequence)"Content-Length", (CharSequence)"0").header((CharSequence)"Host", (CharSequence)"localhost:8080").header((CharSequence)"Origin", (CharSequence)origin).header((CharSequence)"sec-ch-ua", (CharSequence)"\"Not?A_Brand\";v=\"8\", \"Chromium\";v=\"108\", \"Google Chrome\";v=\"108\"").header((CharSequence)"sec-ch-ua-mobile", (CharSequence)"?0").header((CharSequence)"sec-ch-ua-platform", (CharSequence)"\"macOS\"").header((CharSequence)"Sec-Fetch-Dest", (CharSequence)"empty").header((CharSequence)"Sec-Fetch-Mode", (CharSequence)"cors").header((CharSequence)"Sec-Fetch-Site", (CharSequence)"cross-site").header((CharSequence)"User-Agent", (CharSequence)"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36");
    }

    @Requires(property="spec.name", value="SimpleRequestWithCorsNotEnabledTest")
    @Singleton
    static class RefreshCounter
    implements ApplicationEventListener<RefreshEvent> {
        private int refreshCount = 0;

        RefreshCounter() {
        }

        public void onApplicationEvent(RefreshEvent event) {
            ++this.refreshCount;
        }

        public int getRefreshCount() {
            return this.refreshCount;
        }
    }

    @Requires(property="spec.name", value="SimpleRequestWithCorsNotEnabledTest")
    @Controller
    static class RefreshController {
        @Inject
        ApplicationEventPublisher<RefreshEvent> refreshEventApplicationEventPublisher;

        RefreshController() {
        }

        @Post(value="/refresh")
        @Status(value=HttpStatus.OK)
        void refresh() {
            this.refreshEventApplicationEventPublisher.publishEvent((Object)new RefreshEvent());
        }
    }
}

