/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.ServerUnderTest;
import io.micronaut.http.server.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class HttpServerFilterExceptionHandlerTest {
    private static final String SPEC_NAME = "FilterErrorHandlerTest";

    @Test
    public void exceptionHandlerTest() throws IOException {
        HttpServerFilterExceptionHandlerTest.assertion(HttpRequest.GET((String)"/foo"), HttpServerFilterExceptionHandlerTest.throwsStatus(HttpStatus.UNPROCESSABLE_ENTITY));
    }

    private static BiConsumer<ServerUnderTest, HttpRequest<?>> throwsStatus(HttpStatus status) {
        return (server, request) -> AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(status).build());
    }

    private static void assertion(HttpRequest<?> request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request(request).assertion(assertion).run();
    }

    @Requires(property="spec.name", value="FilterErrorHandlerTest")
    @Singleton
    static class FooExceptionHandler
    implements ExceptionHandler<FooException, HttpResponse<?>> {
        private final ErrorResponseProcessor<?> errorResponseProcessor;

        public FooExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor) {
            this.errorResponseProcessor = errorResponseProcessor;
        }

        public HttpResponse<?> handle(HttpRequest request, FooException exception) {
            return this.errorResponseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)exception).build(), HttpResponse.unprocessableEntity());
        }
    }

    @Requires(property="spec.name", value="FilterErrorHandlerTest")
    @Controller(value="/foo")
    static class FooController {
        FooController() {
        }

        @Produces(value={"text/plain"})
        @Get
        String index() {
            return "Hello World";
        }
    }

    @Filter(value={"/**"})
    @Requires(property="spec.name", value="FilterErrorHandlerTest")
    static class ErrorThrowningFilter
    implements HttpServerFilter {
        ErrorThrowningFilter() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            return Mono.error((Throwable)new FooException());
        }
    }

    static class FooException
    extends RuntimeException {
        FooException() {
        }
    }
}

