/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;

public final class BodyAssertion {
    private final String expected;
    private final BiFunction<String, String, Boolean> evaluator;

    private BodyAssertion(String expected, BiFunction<String, String, Boolean> evaluator) {
        this.expected = expected;
        this.evaluator = evaluator;
    }

    public void evaluate(String body) {
        Assertions.assertTrue((boolean)this.evaluator.apply(this.expected, body));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String body;

        public Builder body(String expected) {
            this.body = expected;
            return this;
        }

        public BodyAssertion contains() {
            return new BodyAssertion(this.body, (expected, body) -> body.contains((CharSequence)expected));
        }

        public BodyAssertion equals() {
            return new BodyAssertion(this.body, (expected, body) -> body.equals(expected));
        }
    }
}

