/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteWithoutBodyTest {
    public static final String SPEC_NAME = "DeleteWithoutBodyTest";

    @Test
    void verifiesItIsPossibleToExposesADeleteEndpointWhichIsInvokedWithoutABody() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.DELETE((String)"/sessions/sergio").header((CharSequence)"Authorization", (CharSequence)"Bearer xxx"), (server, request) -> {
            HttpResponse response = (HttpResponse)Assertions.assertDoesNotThrow(() -> server.exchange(request));
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatus());
        });
    }

    @Requires(property="spec.name", value="DeleteWithoutBodyTest")
    @Controller(value="/sessions")
    static class SessionsController {
        SessionsController() {
        }

        @Status(value=HttpStatus.OK)
        @Delete(value="/{username}")
        void delete(@PathVariable String username, @Header(value="Authorization") String authorization) {
        }
    }
}

