/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class StatusTest {
    public static final String SPEC_NAME = "StatusTest";

    @ParameterizedTest
    @ValueSource(strings={"/http-status", "/http-response-status", "/http-exception"})
    void testControllerReturningHttpStatus(String path) throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.GET((String)path), (server, request) -> AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).build()));
    }

    @Produces
    @Singleton
    static class TeapotExceptionHandler
    implements ExceptionHandler<TeapotException, HttpResponse<?>> {
        private final ErrorResponseProcessor<?> errorResponseProcessor;

        TeapotExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor) {
            this.errorResponseProcessor = errorResponseProcessor;
        }

        public HttpResponse<?> handle(HttpRequest request, TeapotException e) {
            return this.errorResponseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)e).build(), HttpResponse.status((HttpStatus)HttpStatus.I_AM_A_TEAPOT));
        }
    }

    static class TeapotException
    extends RuntimeException {
        TeapotException() {
        }
    }

    @Requires(property="spec.name", value="StatusTest")
    @Controller(value="/http-exception")
    static class HttpResponseErrorController {
        HttpResponseErrorController() {
        }

        @Get
        HttpResponse<?> index() {
            throw new TeapotException();
        }
    }

    @Requires(property="spec.name", value="StatusTest")
    @Controller(value="/http-response-status")
    static class HttpResponseStatusController {
        HttpResponseStatusController() {
        }

        @Get
        HttpResponse<?> index() {
            return HttpResponse.status((HttpStatus)HttpStatus.I_AM_A_TEAPOT);
        }
    }

    @Requires(property="spec.name", value="StatusTest")
    @Controller(value="/http-status")
    static class HttpStatusController {
        HttpStatusController() {
        }

        @Get
        HttpStatus index() {
            return HttpStatus.I_AM_A_TEAPOT;
        }
    }
}

