/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.cors;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CorsSimpleRequestTest {
    private static final String SPECNAME = "CorsSimpleRequestTest";
    private static final String PROPERTY_MICRONAUT_SERVER_CORS_ENABLED = "micronaut.server.cors.enabled";

    @Test
    void corsSimpleRequestNotAllowedForLocalhostAndAny() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), CorsSimpleRequestTest.createRequest("https://foo.com"), (server, request) -> {
            RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
            AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.FORBIDDEN).assertResponse(response -> Assertions.assertFalse((boolean)response.getHeaders().contains("Vary"))).build());
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
        });
    }

    @Test
    void corsSimpleRequestAllowedForLocalhostAndOriginLocalhost() throws IOException {
        TestScenario.asserts(SPECNAME, Collections.singletonMap(PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"), CorsSimpleRequestTest.createRequest("http://localhost:8000"), (server, request) -> {
            RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
            AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).build());
            Assertions.assertEquals((int)1, (int)refreshCounter.getRefreshCount());
        });
    }

    @Test
    void corsSimpleRequestForLocalhostCanBeAllowedViaConfiguration() throws IOException {
        TestScenario.asserts(SPECNAME, CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true", "micronaut.server.cors.configurations.foo.allowed-origins", Collections.singletonList("https://foo.com")}), CorsSimpleRequestTest.createRequest("https://foo.com"), (server, request) -> {
            RefreshCounter refreshCounter = (RefreshCounter)server.getApplicationContext().getBean(RefreshCounter.class);
            Assertions.assertEquals((int)0, (int)refreshCounter.getRefreshCount());
            AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
                Assertions.assertNotNull((Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Origin"));
                Assertions.assertNotNull((Object)response.getHeaders().get((CharSequence)"Vary"));
                Assertions.assertNotNull((Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Credentials"));
                Assertions.assertNull((Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Methods"));
                Assertions.assertNull((Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Headers"));
                Assertions.assertNull((Object)response.getHeaders().get((CharSequence)"Access-Control-Max-Age"));
            }).build());
            Assertions.assertEquals((int)1, (int)refreshCounter.getRefreshCount());
        });
    }

    static HttpRequest<?> createRequest(String origin) {
        return HttpRequest.POST((String)"/refresh", (Object)MultipartBody.builder().addPart("force", "true").build()).header((CharSequence)"Content-Type", (CharSequence)"multipart/form-data; boundary=----WebKitFormBoundarywxiDZy8kMlSE59h1").header((CharSequence)"Origin", (CharSequence)origin).header((CharSequence)"Accept-Encoding", (CharSequence)"gzip, deflate").header((CharSequence)"Connection", (CharSequence)"keep-alive").header((CharSequence)"Accept", (CharSequence)"*/*").header((CharSequence)"User-Agent", (CharSequence)"Mozilla / 5.0 (Macintosh; Intel Mac OS X 10_15_7)AppleWebKit / 605.1 .15 (KHTML, like Gecko)Version / 16.1 Safari / 605.1 .15").header((CharSequence)"Referer", (CharSequence)origin).header((CharSequence)"Accept-Language", (CharSequence)"en - GB, en").header((CharSequence)"content-length", (CharSequence)"140");
    }

    @Requires(property="spec.name", value="CorsSimpleRequestTest")
    @Singleton
    static class RefreshCounter
    implements ApplicationEventListener<RefreshEvent> {
        private int refreshCount = 0;

        RefreshCounter() {
        }

        public void onApplicationEvent(RefreshEvent event) {
            ++this.refreshCount;
        }

        public int getRefreshCount() {
            return this.refreshCount;
        }
    }

    @Requires(property="spec.name", value="CorsSimpleRequestTest")
    @Controller
    static class RefreshController {
        @Inject
        ApplicationEventPublisher<RefreshEvent> refreshEventApplicationEventPublisher;

        RefreshController() {
        }

        @Consumes(value={"multipart/form-data"})
        @Post(value="/refresh")
        @Status(value=HttpStatus.OK)
        void refresh() {
            this.refreshEventApplicationEventPublisher.publishEvent((Object)new RefreshEvent());
        }
    }
}

