/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.server.tck.BodyAssertion;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.ServerUnderTest;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

public final class AssertionUtils {
    private AssertionUtils() {
    }

    public static void assertThrows(@NonNull ServerUnderTest server, @NonNull HttpRequest<?> request, @NonNull HttpResponseAssertion assertion) {
        Executable e = assertion.getBody() != null ? () -> server.exchange(request, String.class) : () -> server.exchange(request);
        HttpClientResponseException thrown = (HttpClientResponseException)Assertions.assertThrows(HttpClientResponseException.class, (Executable)e);
        HttpResponse response = thrown.getResponse();
        Assertions.assertEquals((Object)assertion.getHttpStatus(), (Object)response.getStatus());
        AssertionUtils.assertHeaders(response, assertion.getHeaders());
        AssertionUtils.assertBody(response, assertion.getBody());
        assertion.getResponseConsumer().ifPresent(httpResponseConsumer -> httpResponseConsumer.accept(response));
    }

    public static void assertThrows(@NonNull ServerUnderTest server, @NonNull HttpRequest<?> request, @NonNull HttpStatus expectedStatus, @Nullable String expectedBody, @Nullable Map<String, String> expectedHeaders) {
        AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(expectedStatus).body(expectedBody).headers(expectedHeaders).build());
    }

    public static <T> void assertDoesNotThrow(@NonNull ServerUnderTest server, @NonNull HttpRequest<T> request, @NonNull HttpStatus expectedStatus, @Nullable String expectedBody, @Nullable Map<String, String> expectedHeaders) {
        AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(expectedStatus).body(expectedBody).headers(expectedHeaders).build());
    }

    public static <T> void assertDoesNotThrow(@NonNull ServerUnderTest server, @NonNull HttpRequest<T> request, @NonNull HttpResponseAssertion assertion) {
        ThrowingSupplier executable = assertion.getBody() != null ? () -> server.exchange(request, String.class) : () -> server.exchange(request);
        HttpResponse response = (HttpResponse)Assertions.assertDoesNotThrow((ThrowingSupplier)executable);
        Assertions.assertEquals((Object)assertion.getHttpStatus(), (Object)response.getStatus());
        AssertionUtils.assertHeaders(response, assertion.getHeaders());
        AssertionUtils.assertBody(response, assertion.getBody());
        assertion.getResponseConsumer().ifPresent(httpResponseConsumer -> httpResponseConsumer.accept(response));
    }

    private static <T> void assertBody(@NonNull HttpResponse<?> response, @Nullable BodyAssertion<T> bodyAssertion) {
        if (bodyAssertion != null) {
            Optional bodyOptional = response.getBody(bodyAssertion.getBodyType());
            Assertions.assertTrue((boolean)bodyOptional.isPresent());
            bodyOptional.ifPresent(bodyAssertion::evaluate);
        }
    }

    private static void assertHeaders(@NonNull HttpResponse<?> response, @Nullable Map<String, String> expectedHeaders) {
        if (expectedHeaders != null) {
            for (Map.Entry<String, String> expectedHeadersEntrySet : expectedHeaders.entrySet()) {
                String headerName = expectedHeadersEntrySet.getKey();
                Optional headerOptional = response.getHeaders().getFirst((CharSequence)headerName);
                Assertions.assertTrue((boolean)headerOptional.isPresent(), () -> "Header " + headerName + " not present");
                headerOptional.ifPresent(headerValue -> {
                    String expectedValue = (String)expectedHeadersEntrySet.getValue();
                    if (headerName.equals("Content-Type")) {
                        if (headerValue.contains(";charset=")) {
                            Assertions.assertTrue((boolean)headerValue.startsWith(expectedValue), () -> "header value " + headerValue + " does not start with " + expectedValue);
                        } else {
                            Assertions.assertEquals((Object)expectedValue, headerOptional.get());
                        }
                    } else {
                        Assertions.assertEquals((Object)expectedValue, headerOptional.get());
                    }
                });
            }
        }
    }
}

