/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import java.util.Arrays;
import java.util.function.BiPredicate;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BodyAssertion<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BodyAssertion.class);
    private final Class<T> bodyType;
    private final T expected;
    private final BiPredicate<T, T> evaluator;

    private BodyAssertion(Class<T> bodyType, T expected, BiPredicate<T, T> evaluator) {
        this.bodyType = bodyType;
        this.expected = expected;
        this.evaluator = evaluator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void evaluate(T body) {
        Assertions.assertTrue((boolean)this.evaluator.test(this.expected, body), (String)("Expected [" + this.expected + "] but was [" + body + "]"));
    }

    public Class<T> getBodyType() {
        return this.bodyType;
    }

    public static class ByteArrayBodyAssertionBuilder
    extends Builder
    implements AssertionBuilder<byte[]> {
        private final byte[] body;

        public ByteArrayBodyAssertionBuilder(byte[] expected) {
            this.body = expected;
        }

        @Override
        public BodyAssertion<byte[]> contains() {
            return new BodyAssertion<byte[]>(byte[].class, this.body, (required, received) -> {
                throw new AssertionError((Object)"Not implemented yet!");
            });
        }

        @Override
        public BodyAssertion<byte[]> equals() {
            return new BodyAssertion<byte[]>(byte[].class, this.body, (required, received) -> Arrays.equals(received, required));
        }
    }

    public static class StringBodyAssertionBuilder
    extends Builder
    implements AssertionBuilder<String> {
        private final String body;

        public StringBodyAssertionBuilder(String expected) {
            this.body = expected;
        }

        @Override
        public BodyAssertion<String> contains() {
            return new BodyAssertion<String>(String.class, this.body, (required, received) -> {
                boolean result = received.contains((CharSequence)required);
                if (!result) {
                    LOG.warn("The following body does not contains {}.\n{}\n", required, received);
                }
                return result;
            });
        }

        @Override
        public BodyAssertion<String> equals() {
            return new BodyAssertion<String>(String.class, this.body, (required, received) -> received.equals(required));
        }
    }

    public static class Builder {
        public AssertionBuilder<String> body(String expected) {
            return new StringBodyAssertionBuilder(expected);
        }

        public AssertionBuilder<byte[]> body(byte[] expected) {
            return new ByteArrayBodyAssertionBuilder(expected);
        }
    }

    public static interface AssertionBuilder<T> {
        public BodyAssertion<T> contains();

        public BodyAssertion<T> equals();
    }
}

