/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.tck.RequestSupplier;
import io.micronaut.http.server.tck.ServerUnderTest;
import io.micronaut.http.server.tck.ServerUnderTestProviderUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class TestScenario {
    private final String specName;
    private final Map<String, Object> configuration;
    private final RequestSupplier request;
    private final BiConsumer<ServerUnderTest, HttpRequest<?>> assertion;

    private TestScenario(String specName, Map<String, Object> configuration, RequestSupplier request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) {
        this.specName = specName;
        this.configuration = configuration;
        this.request = request;
        this.assertion = assertion;
    }

    public static void asserts(String specName, Map<String, Object> configuration, HttpRequest<?> request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(specName).configuration(configuration).request(request).assertion(assertion).run();
    }

    public static void asserts(String specName, Map<String, Object> configuration, RequestSupplier request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(specName).configuration(configuration).request(request).assertion(assertion).run();
    }

    public static void asserts(String specName, HttpRequest<?> request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(specName).request(request).assertion(assertion).run();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void run() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(this.specName, this.configuration);){
            if (this.assertion != null) {
                this.assertion.accept(server, (HttpRequest)this.request.apply(server));
            }
        }
    }

    public static class Builder {
        private Map<String, Object> configuration;
        private String specName;
        private BiConsumer<ServerUnderTest, HttpRequest<?>> assertion;
        private RequestSupplier request;

        public Builder specName(String specName) {
            this.specName = specName;
            return this;
        }

        public Builder request(HttpRequest<?> request) {
            this.request = server -> request;
            return this;
        }

        public Builder request(RequestSupplier request) {
            this.request = request;
            return this;
        }

        public Builder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder assertion(BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) {
            this.assertion = assertion;
            return this;
        }

        private TestScenario build() {
            return new TestScenario(this.specName, this.configuration, Objects.requireNonNull(this.request), Objects.requireNonNull(this.assertion));
        }

        public void run() throws IOException {
            this.build().run();
        }
    }
}

