/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;

public class FilterErrorTest {
    public static final String SPEC_NAME = "FilterErrorTest";

    @Test
    void testFilterThrowingExceptionHandledByExceptionHandlerThrowingException() throws IOException {
        TestScenario.asserts("FilterErrorTest3", HttpRequest.GET((String)"/filter-error-spec-3").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> {
            AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.INTERNAL_SERVER_ERROR).body("from exception handler").build());
            ExceptionException filter = (ExceptionException)server.getApplicationContext().getBean(ExceptionException.class);
            Assertions.assertEquals((int)1, (int)filter.executedCount.get());
            Assertions.assertEquals((Object)HttpStatus.INTERNAL_SERVER_ERROR, filter.responseStatus.getAndSet(null));
        });
    }

    @Test
    void testTheErrorRouteIsTheRouteMatch() throws IOException {
        TestScenario.asserts("FilterErrorTest4", HttpRequest.GET((String)"/filter-error-spec-4/status").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> {
            AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).build());
            ExceptionRoute filter = (ExceptionRoute)server.getApplicationContext().getBean(ExceptionRoute.class);
            RouteMatch match = filter.routeMatch.getAndSet(null);
            Assertions.assertTrue((boolean)(match instanceof MethodBasedRouteMatch));
            Assertions.assertEquals((Object)"testStatus", (Object)((MethodBasedRouteMatch)match).getName());
        });
    }

    @Test
    void testNonOncePerRequestFilterThrowingErrorDoesNotLoop() throws IOException {
        TestScenario.asserts("FilterErrorTest2", HttpRequest.GET((String)"/filter-error-spec").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> {
            AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).body("from filter exception handler").build());
            FirstEvery filter = (FirstEvery)server.getApplicationContext().getBean(FirstEvery.class);
            Assertions.assertEquals((int)1, (int)filter.executedCount.get());
        });
    }

    @Test
    void testErrorsEmittedFromSecondFilterInteractingWithExceptionHandlers() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.GET((String)"/filter-error-spec").header((CharSequence)"Content-Type", (CharSequence)"application/json").header((CharSequence)"X-Passthru", (CharSequence)"true"), (server, request) -> {
            AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).body("from NEXT filter exception handle").build());
            First first = (First)server.getApplicationContext().getBean(First.class);
            Next next = (Next)server.getApplicationContext().getBean(Next.class);
            Assertions.assertEquals((int)1, (int)first.executedCount.get());
            Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, first.responseStatus.getAndSet(null));
            Assertions.assertEquals((int)1, (int)next.executedCount.get());
        });
    }

    @Test
    void testErrorsEmittedFromFiltersInteractingWithExceptionHandlers() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.GET((String)"/filter-error-spec").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> {
            AssertionUtils.assertThrows(server, request, HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).body("from filter exception handler").build());
            First first = (First)server.getApplicationContext().getBean(First.class);
            Next next = (Next)server.getApplicationContext().getBean(Next.class);
            Assertions.assertEquals((int)1, (int)first.executedCount.get());
            Assertions.assertNull(first.responseStatus.getAndSet(null));
            Assertions.assertEquals((int)0, (int)next.executedCount.get());
        });
    }

    @Requires(condition=FilterCondition.class)
    @Singleton
    static class NextFilterExceptionHandler
    implements ExceptionHandler<NextFilterException, HttpResponse<?>> {
        NextFilterExceptionHandler() {
        }

        public HttpResponse<?> handle(HttpRequest request, NextFilterException exception) {
            return HttpResponse.badRequest((Object)"from NEXT filter exception handler");
        }
    }

    @Requires(condition=FilterCondition.class)
    @Singleton
    static class FilterExceptionHandler
    implements ExceptionHandler<FilterException, HttpResponse<?>> {
        FilterExceptionHandler() {
        }

        public HttpResponse<?> handle(HttpRequest request, FilterException exception) {
            return HttpResponse.badRequest((Object)"from filter exception handler");
        }
    }

    @Requires(condition=FilterCondition.class)
    @Singleton
    static class FilterExceptionExceptionHandler
    implements ExceptionHandler<FilterExceptionException, HttpResponse<?>> {
        FilterExceptionExceptionHandler() {
        }

        public HttpResponse<?> handle(HttpRequest request, FilterExceptionException exception) {
            throw new RuntimeException("from exception handler");
        }
    }

    static class FilterCondition
    implements Condition {
        FilterCondition() {
        }

        public boolean matches(ConditionContext context) {
            return context.getProperty("spec.name", String.class).map(val -> val.equals("FilterErrorTest4") || val.equals("FilterErrorTest3") || val.equals("FilterErrorTest2") || val.equals(FilterErrorTest.SPEC_NAME)).orElse(false);
        }
    }

    @Requires(condition=FilterCondition.class)
    @Controller(value="/filter-error-spec-4")
    static class HandledByErrorRouteController {
        HandledByErrorRouteController() {
        }

        @Get(value="/exception")
        String getException() {
            throw new FilterExceptionException();
        }

        @Get(value="/status")
        HttpStatus getStatus() {
            return HttpStatus.NOT_FOUND;
        }

        @Error(exception=FilterExceptionException.class)
        @Status(value=HttpStatus.OK)
        void testException() {
        }

        @Error(status=HttpStatus.NOT_FOUND)
        @Status(value=HttpStatus.OK)
        void testStatus() {
        }
    }

    @Requires(condition=FilterCondition.class)
    @Controller(value="/filter-error-spec-3")
    static class HandledByHandlerController {
        HandledByHandlerController() {
        }

        @Get
        String get() {
            throw new FilterExceptionException();
        }
    }

    @Requires(condition=FilterCondition.class)
    @Controller(value="/filter-error-spec")
    static class NeverReachedController {
        NeverReachedController() {
        }

        @Get
        String get() {
            return "OK";
        }
    }

    @Requires(property="spec.name", value="FilterErrorTest4")
    @Filter(value={"/**"})
    static class ExceptionRoute
    implements HttpServerFilter {
        AtomicReference<RouteMatch<?>> routeMatch = new AtomicReference();

        ExceptionRoute() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            return Publishers.then((Publisher)chain.proceed(request), httpResponse -> this.routeMatch.set((RouteMatch)httpResponse.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).get()));
        }

        public int getOrder() {
            return 10;
        }
    }

    @Requires(property="spec.name", value="FilterErrorTest3")
    @Filter(value={"/**"})
    static class ExceptionException
    implements HttpServerFilter {
        AtomicInteger executedCount = new AtomicInteger(0);
        AtomicReference<HttpStatus> responseStatus = new AtomicReference();

        ExceptionException() {
        }

        private void setResponse(MutableHttpResponse<?> r) {
            this.responseStatus.set(r.status());
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            this.executedCount.incrementAndGet();
            return Publishers.then((Publisher)chain.proceed(request), this::setResponse);
        }

        public int getOrder() {
            return 10;
        }
    }

    @Requires(property="spec.name", value="FilterErrorTest2")
    @Filter(value={"/**"})
    static class FirstEvery
    implements HttpServerFilter {
        AtomicInteger executedCount = new AtomicInteger(0);

        FirstEvery() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            this.executedCount.incrementAndGet();
            return Publishers.just((Throwable)new FilterException());
        }

        public int getOrder() {
            return 10;
        }
    }

    @Requires(property="spec.name", value="FilterErrorTest")
    @Filter(value={"/**"})
    static class Next
    implements HttpServerFilter {
        AtomicInteger executedCount = new AtomicInteger(0);

        Next() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            this.executedCount.incrementAndGet();
            return Publishers.just((Throwable)new NextFilterException());
        }

        public int getOrder() {
            return 20;
        }
    }

    @Requires(property="spec.name", value="FilterErrorTest")
    @Filter(value={"/**"})
    static class First
    implements HttpServerFilter {
        AtomicInteger executedCount = new AtomicInteger(0);
        AtomicReference<HttpStatus> responseStatus = new AtomicReference();

        First() {
        }

        private void setResponse(MutableHttpResponse<?> r) {
            this.responseStatus.set(r.status());
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            this.executedCount.incrementAndGet();
            if (StringUtils.isTrue((String)((String)request.getHeaders().get((CharSequence)"X-Passthru")))) {
                return Publishers.then((Publisher)chain.proceed(request), this::setResponse);
            }
            return Publishers.just((Throwable)new FilterException());
        }

        public int getOrder() {
            return 10;
        }
    }

    static class NextFilterException
    extends RuntimeException {
        NextFilterException() {
        }
    }

    static class FilterException
    extends RuntimeException {
        FilterException() {
        }
    }

    static class FilterExceptionException
    extends RuntimeException {
        FilterExceptionException() {
        }
    }
}

