/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ErrorHandlerStringTest {
    public static final String SPEC_NAME = "ErrorHandlerStringTest";

    @Test
    void testErrorHandlerWithStringReturn() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/exception/my").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpStatus)HttpStatus.OK, (String)"hello", Map.of("Content-Type", "application/json")));
    }

    @Requires(property="spec.name", value="ErrorHandlerStringTest")
    @Singleton
    static class MyExceptionHandler
    implements ExceptionHandler<MyException, String> {
        MyExceptionHandler() {
        }

        public String handle(HttpRequest request, MyException exception) {
            return "hello";
        }
    }

    static class MyException
    extends RuntimeException {
        public MyException(String badThings) {
            super(badThings);
        }
    }

    @Requires(property="spec.name", value="ErrorHandlerStringTest")
    @Controller(value="/exception")
    static class ExceptionController {
        ExceptionController() {
        }

        @Get(value="/my")
        void throwsMy() {
            throw new MyException("bad");
        }
    }
}

