/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.RouteCondition;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Test;

public class ExpressionTest {
    public static final String SPEC_NAME = "ExpressionTest";

    @Test
    void testConditionalGetRequest() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/expr/test"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).build()));
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/expr/test").header((CharSequence)"Authorization", (CharSequence)"foo"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("ok").build()));
    }

    @Controller(value="/expr")
    @Requires(property="spec.name", value="ExpressionTest")
    static class ExpressionController {
        ExpressionController() {
        }

        @Get(value="/test")
        @RouteCondition(value="#{request.headers.getFirst('Authorization')?.contains('foo')}")
        String testGet() {
            return "ok";
        }
    }
}

