/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ErrorHandlerTest {
    public static final String SPEC_NAME = "ErrorHandlerTest";
    public static final String PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS = "micronaut.server.cors.configurations.web.allowed-origins";
    public static final String PROPERTY_MICRONAUT_SERVER_CORS_ENABLED = "micronaut.server.cors.enabled";
    public static final String LOCALHOST = "http://localhost:8080";

    @Test
    void testCustomGlobalExceptionHandlersDeclaredInController() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.GET((String)"/errors/global-ctrl").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpStatus)HttpStatus.OK, (String)"bad things happens globally", Collections.singletonMap("Content-Type", "text/plain")));
    }

    @Test
    void testCustomGlobalExceptionHandlers() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.GET((String)"/errors/global").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpStatus)HttpStatus.OK, (String)"Exception Handled", Collections.singletonMap("Content-Type", "text/plain")));
    }

    @Test
    void testCustomGlobalExceptionHandlersForPOSTWithBody() throws IOException {
        Map configuration = CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"});
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, configuration);){
            JsonMapper objectMapper = (JsonMapper)server.getApplicationContext().getBean(JsonMapper.class);
            MutableHttpRequest request = HttpRequest.POST((String)"/json/errors/global", (Object)objectMapper.writeValueAsString((Object)new RequestObject(101))).header((CharSequence)"Content-Type", (CharSequence)"application/json");
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpStatus)HttpStatus.OK, (String)"\"message\":\"Error: bad things when post and body in request\"", Collections.singletonMap("Content-Type", "application/json"));
        }
    }

    @Test
    void testCustomGlobalStatusHandlersDeclaredInController() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.GET((String)"/errors/global-status-ctrl"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpStatus)HttpStatus.OK, (String)"global status", Collections.singletonMap("Content-Type", "text/plain")));
    }

    @Test
    void testLocalExceptionHandlers() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.GET((String)"/errors/local"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpStatus)HttpStatus.OK, (String)"bad things", Collections.singletonMap("Content-Type", "text/plain")));
    }

    @Test
    void jsonMessageFormatErrorsReturn400() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.POST((String)"/json/jsonBody", (Object)"{\"numberField\": \"textInsteadOfNumber\"}"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).headers(Collections.singletonMap("Content-Type", "application/json")).build()));
    }

    @Test
    void corsHeadersArePresentAfterFailedDeserialisationWhenErrorHandlerIsUsed() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.POST((String)"/json/errors/global", (Object)"{\"numberField\": \"string is not a number\"}").header((CharSequence)"Origin", (CharSequence)LOCALHOST), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).headers(Collections.singletonMap("Access-Control-Allow-Origin", LOCALHOST)).build()));
    }

    @Test
    void corsHeadersArePresentAfterFailedDeserialisation() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.POST((String)"/json/jsonBody", (Object)"{\"numberField\": \"string is not a number\"}").header((CharSequence)"Origin", (CharSequence)LOCALHOST), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).headers(Collections.singletonMap("Access-Control-Allow-Origin", LOCALHOST)).build()));
    }

    @Test
    void corsHeadersArePresentAfterExceptions() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.GET((String)"/errors/global").header((CharSequence)"Origin", (CharSequence)LOCALHOST), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).headers(Collections.singletonMap("Access-Control-Allow-Origin", LOCALHOST)).build()));
    }

    @Test
    void messageValidationErrorsReturn400() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{PROPERTY_MICRONAUT_SERVER_CORS_CONFIGURATIONS_WEB_ALLOWED_ORIGINS, Collections.singletonList(LOCALHOST), PROPERTY_MICRONAUT_SERVER_CORS_ENABLED, "true"}), (HttpRequest)HttpRequest.POST((String)"/json/jsonBody", (Object)"{\"numberField\": 0}"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).headers(Collections.singletonMap("Content-Type", "application/json")).build()));
    }

    @Introspected
    static class RequestObject {
        @Min(value=1L)
        private @Min(value=1L) Integer numberField;

        public RequestObject(Integer numberField) {
            this.numberField = numberField;
        }

        public Integer getNumberField() {
            return this.numberField;
        }
    }

    static class GloballyHandledException
    extends Exception {
        public GloballyHandledException(String badThingsHappensGlobally) {
            super(badThingsHappensGlobally);
        }
    }

    static class AnotherException
    extends RuntimeException {
        public AnotherException(String badThings) {
            super(badThings);
        }
    }

    static class MyException
    extends RuntimeException {
        public MyException(String badThings) {
            super(badThings);
        }
    }

    @Singleton
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class MyErrorHandler
    implements ExceptionHandler<MyException, HttpResponse> {
        MyErrorHandler() {
        }

        public HttpResponse handle(HttpRequest request, MyException exception) {
            return HttpResponse.ok((Object)"Exception Handled").contentType((CharSequence)"text/plain");
        }
    }

    @Singleton
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class RuntimeErrorHandler
    implements ExceptionHandler<RuntimeException, HttpResponse> {
        RuntimeErrorHandler() {
        }

        public HttpResponse handle(HttpRequest request, RuntimeException exception) {
            return HttpResponse.serverError((Object)("Exception: " + exception.getMessage())).contentType((CharSequence)"text/plain");
        }
    }

    @Singleton
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class CodecExceptionExceptionHandler
    implements ExceptionHandler<CodecException, HttpResponse> {
        CodecExceptionExceptionHandler() {
        }

        public HttpResponse handle(HttpRequest request, CodecException exception) {
            return HttpResponse.badRequest((Object)("Invalid JSON: " + exception.getMessage())).contentType((CharSequence)"application/json");
        }
    }

    @Controller(value="/global-errors")
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class GlobalErrorController {
        GlobalErrorController() {
        }

        @Error(global=true, exception=GloballyHandledException.class)
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        String globallyHandledException(GloballyHandledException throwable) {
            return throwable.getMessage();
        }

        @Error(global=true, status=HttpStatus.I_AM_A_TEAPOT)
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        String globalControllerHandlerForStatus() {
            return "global status";
        }
    }

    @Controller(value="/json")
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class JsonController {
        JsonController() {
        }

        @Post(value="/jsonBody")
        String jsonBody(@Valid @Body RequestObject data) {
            return "blah";
        }
    }

    @Controller(value="/json/errors", produces={"application/json"})
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class JsonErrorController {
        JsonErrorController() {
        }

        @Post(value="/global")
        String globalHandlerPost(@Body RequestObject object) {
            throw new RuntimeException("bad things when post and body in request");
        }

        @Error
        HttpResponse<JsonError> errorHandler(HttpRequest request, RuntimeException exception) {
            JsonError error = (JsonError)new JsonError("Error: " + exception.getMessage()).link(Link.SELF, Link.of((URI)request.getUri()));
            return HttpResponse.status((HttpStatus)HttpStatus.OK).body((Object)error);
        }
    }

    @Requires(property="spec.name", value="ErrorHandlerTest")
    @Controller(value="/errors")
    static class ErrorController {
        ErrorController() {
        }

        @Get(value="/global")
        String globalHandler() {
            throw new MyException("bad things");
        }

        @Get(value="/global-ctrl")
        String globalControllerHandler() throws GloballyHandledException {
            throw new GloballyHandledException("bad things happens globally");
        }

        @Get(value="/global-status-ctrl")
        @Status(value=HttpStatus.I_AM_A_TEAPOT)
        String globalControllerHandlerForStatus() {
            return "original global status";
        }

        @Get(value="/local")
        String localHandler() {
            throw new AnotherException("bad things");
        }

        @Error
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        String localHandler(AnotherException throwable) {
            return throwable.getMessage();
        }
    }

    @Controller(value="/secret")
    @Requires(property="spec.name", value="ErrorHandlerTest")
    static class SecretController {
        SecretController() {
        }

        @Get
        @Produces(value={"text/plain"})
        String index() {
            return "area 51 hosts an alien";
        }
    }
}

