/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import jakarta.annotation.security.RolesAllowed;
import java.io.IOException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class HttpServerFilterTest {
    private static final String PATH = "/http-server-filter-test";
    private static final String SPEC_NAME = "HttpServerFilterTest";

    @Test
    public void httpServerFilterTest() throws IOException {
        HttpServerFilterTest.assertion(HttpRequest.GET((String)PATH), HttpServerFilterTest.throwsStatus(HttpStatus.UNAUTHORIZED));
        HttpServerFilterTest.assertion(HttpRequest.GET((String)PATH).header((CharSequence)"Authorization", (CharSequence)"ROLE_USER"), HttpServerFilterTest.throwsStatus(HttpStatus.FORBIDDEN));
        BiConsumer<ServerUnderTest, HttpRequest<?>> okAssertion = (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
        HttpServerFilterTest.assertion(HttpRequest.GET((String)PATH).header((CharSequence)"Authorization", (CharSequence)"ROLE_ADMIN"), okAssertion);
        HttpServerFilterTest.assertion(HttpRequest.GET((String)"/open"), okAssertion);
    }

    private static BiConsumer<ServerUnderTest, HttpRequest<?>> throwsStatus(HttpStatus status) {
        return (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(status).build());
    }

    private static void assertion(HttpRequest<?> request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request(request).assertion(assertion).run();
    }

    @Controller
    @Requires(property="spec.name", value="HttpServerFilterTest")
    public static class MyController {
        @RolesAllowed(value={"ROLE_ADMIN"})
        @Get(value="/http-server-filter-test")
        public String rolesAllowed(HttpRequest<?> request) {
            return "foo";
        }

        @Get(value="/open")
        public String open(HttpRequest<?> request) {
            return "foo";
        }
    }

    @Filter(value={"/**"})
    @Requires(property="spec.name", value="HttpServerFilterTest")
    static class SecurityFilter
    implements HttpServerFilter {
        SecurityFilter() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            MethodBasedRouteMatch methodRoute;
            RouteMatch routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).orElse(null);
            if (routeMatch instanceof MethodBasedRouteMatch && (methodRoute = (MethodBasedRouteMatch)routeMatch).hasAnnotation(RolesAllowed.class)) {
                String role = (String)request.getHeaders().get((CharSequence)"Authorization");
                if (role == null) {
                    return Mono.fromCallable(() -> HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED));
                }
                Optional optionalValue = methodRoute.getValue(RolesAllowed.class, String[].class);
                if (optionalValue.isPresent()) {
                    String[] roles = (String[])optionalValue.get();
                    if (role != null && Stream.of(roles).anyMatch(r -> r.equals(role))) {
                        return chain.proceed(request);
                    }
                }
                return Mono.fromCallable(() -> HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN));
            }
            return chain.proceed(request);
        }
    }
}

