/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseFilterTest {
    public static final String SPEC_NAME = "ResponseFilterTest";

    @Test
    public void responseFilterImmediateRequestParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/immediate-request-parameter")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("responseFilterImmediateRequestParameter /response-filter/immediate-request-parameter"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void responseFilterImmediateMutableRequestParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/immediate-mutable-request-parameter")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("responseFilterImmediateMutableRequestParameter /response-filter/immediate-mutable-request-parameter"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void responseFilterResponseParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/response-parameter")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("responseFilterResponseParameter foo"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void responseFilterMutableResponseParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/mutable-response-parameter")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterMutableResponseParameter foo").build())).run();
    }

    @Test
    public void responseFilterThrowableParameterNotCalledForControllerError() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/throwable-parameter")).assertion((server, request) -> {
            AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.INTERNAL_SERVER_ERROR).build());
            Assertions.assertEquals(List.of(), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void responseFilterReplaceResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterReplaceResponse foo").build())).run();
    }

    @Test
    public void responseFilterReplaceMutableResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-mutable-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterReplaceMutableResponse foo").build())).run();
    }

    @Test
    public void responseFilterReplaceResponseNull() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-response-null")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build())).run();
    }

    @Test
    public void responseFilterReplaceResponseEmpty() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-response-empty")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build())).run();
    }

    @Test
    public void responseFilterReplacePublisherResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-publisher-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterReplacePublisherResponse foo").build())).run();
    }

    @Test
    public void responseFilterReplaceMonoResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-mono-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterReplaceMonoResponse foo").build())).run();
    }

    @Test
    public void responseFilterReplaceCompletableResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-completable-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterReplaceCompletableResponse foo").build())).run();
    }

    @Test
    public void responseFilterReplaceCompletionResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-filter/replace-completion-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("responseFilterReplaceCompletionResponse foo").build())).run();
    }

    @ServerFilter
    @Singleton
    @Requires(property="spec.name", value="ResponseFilterTest")
    public static class MyServerFilter {
        List<String> events = new ArrayList<String>();

        @ResponseFilter(value={"/response-filter/immediate-request-parameter"})
        public void responseFilterImmediateRequestParameter(HttpRequest<?> request) {
            this.events.add("responseFilterImmediateRequestParameter " + request.getPath());
        }

        @ResponseFilter(value={"/response-filter/immediate-mutable-request-parameter"})
        public void responseFilterImmediateMutableRequestParameter(MutableHttpRequest<?> request) {
            this.events.add("responseFilterImmediateMutableRequestParameter " + request.getPath());
        }

        @ResponseFilter(value={"/response-filter/response-parameter"})
        public void responseFilterResponseParameter(HttpResponse<?> response) {
            this.events.add("responseFilterResponseParameter " + response.body());
        }

        @ResponseFilter(value={"/response-filter/mutable-response-parameter"})
        public void responseFilterMutableResponseParameter(MutableHttpResponse<?> response) {
            response.body((Object)("responseFilterMutableResponseParameter " + response.body()));
        }

        @ResponseFilter(value={"/response-filter/throwable-parameter"})
        public void responseFilterThrowableParameter(Throwable t) {
            this.events.add("responseFilterThrowableParameter " + t.getMessage());
        }

        @ResponseFilter(value={"/response-filter/replace-response"})
        public HttpResponse<?> responseFilterReplaceResponse(HttpResponse<?> response) {
            return HttpResponse.ok((Object)("responseFilterReplaceResponse " + response.body()));
        }

        @ResponseFilter(value={"/response-filter/replace-mutable-response"})
        public MutableHttpResponse<?> responseFilterReplaceMutableResponse(HttpResponse<?> response) {
            return HttpResponse.ok((Object)("responseFilterReplaceMutableResponse " + response.body()));
        }

        @ResponseFilter(value={"/response-filter/replace-response-null"})
        @Nullable
        public HttpResponse<?> responseFilterReplaceResponseNull() {
            return null;
        }

        @ResponseFilter(value={"/response-filter/replace-response-empty"})
        public Optional<HttpResponse<?>> responseFilterReplaceResponseEmpty() {
            return Optional.empty();
        }

        @ResponseFilter(value={"/response-filter/replace-publisher-response"})
        public Publisher<MutableHttpResponse<?>> responseFilterReplacePublisherResponse(HttpResponse<?> response) {
            return Flux.just((Object)HttpResponse.ok((Object)("responseFilterReplacePublisherResponse " + response.body())));
        }

        @ResponseFilter(value={"/response-filter/replace-mono-response"})
        public Mono<MutableHttpResponse<?>> responseFilterReplaceMonoResponse(HttpResponse<?> response) {
            return Mono.just((Object)HttpResponse.ok((Object)("responseFilterReplaceMonoResponse " + response.body())));
        }

        @ResponseFilter(value={"/response-filter/replace-completable-response"})
        public CompletableFuture<MutableHttpResponse<?>> responseFilterReplaceCompletableResponse(HttpResponse<?> response) {
            return CompletableFuture.completedFuture(HttpResponse.ok((Object)("responseFilterReplaceCompletableResponse " + response.body())));
        }

        @ResponseFilter(value={"/response-filter/replace-completion-response"})
        public CompletionStage<MutableHttpResponse<?>> responseFilterReplaceCompletionResponse(HttpResponse<?> response) {
            return CompletableFuture.completedStage(HttpResponse.ok((Object)("responseFilterReplaceCompletionResponse " + response.body())));
        }
    }

    @Controller
    @Requires(property="spec.name", value="ResponseFilterTest")
    public static class MyController {
        @Get(value="/response-filter/immediate-request-parameter")
        public String responseFilterImmediateRequestParameter() {
            return "foo";
        }

        @Get(value="/response-filter/immediate-mutable-request-parameter")
        public String responseFilterImmediateMutableRequestParameter() {
            return "foo";
        }

        @Get(value="/response-filter/response-parameter")
        public String responseFilterResponseParameter() {
            return "foo";
        }

        @Get(value="/response-filter/mutable-response-parameter")
        public String responseFilterMutableResponseParameter() {
            return "foo";
        }

        @Get(value="/response-filter/throwable-parameter")
        public String responseFilterThrowableParameter() {
            throw new RuntimeException("foo");
        }

        @Get(value="/response-filter/replace-response")
        public String responseFilterReplaceResponse() {
            return "foo";
        }

        @Get(value="/response-filter/replace-mutable-response")
        public String responseFilterReplaceMutableResponse() {
            return "foo";
        }

        @Get(value="/response-filter/replace-response-null")
        public String responseFilterReplaceResponseNull() {
            return "foo";
        }

        @Get(value="/response-filter/replace-response-empty")
        public String responseFilterReplaceResponseEmpty() {
            return "foo";
        }

        @Get(value="/response-filter/replace-publisher-response")
        public String responseFilterReplacePublisherResponse() {
            return "foo";
        }

        @Get(value="/response-filter/replace-mono-response")
        public String responseFilterReplaceMonoResponse() {
            return "foo";
        }

        @Get(value="/response-filter/replace-completable-response")
        public String responseFilterReplaceCompletableResponse() {
            return "foo";
        }

        @Get(value="/response-filter/replace-completion-response")
        public String responseFilterReplaceCompletionResponse() {
            return "foo";
        }
    }
}

