/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class VersionTest {
    public static final String SPEC_NAME = "VersionTest";

    @Test
    void testControllerMethodWithVersion2() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (Map)CollectionUtils.mapOf((Object[])new Object[]{"micronaut.router.versioning.enabled", "true", "micronaut.router.versioning.header.enabled", "true"}), (HttpRequest)HttpRequest.GET((String)"/version/ping").header((CharSequence)"X-API-VERSION", (CharSequence)"2"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("pong v2").build()));
    }

    @Controller(value="/version")
    @Requires(property="spec.name", value="VersionTest")
    static class ConsumesController {
        ConsumesController() {
        }

        @Get(value="/ping")
        String pingV1() {
            return "pong v1";
        }

        @Version(value="2")
        @Get(value="/ping")
        String pingV2() {
            return "pong v2";
        }
    }
}

