/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import reactor.core.publisher.Flux;

public class ErrorHandlerFluxTest {
    public static final String SPEC_NAME = "ErrorHandlerFluxTest";

    @Test
    void testErrorHandlerWithFluxThrownException() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/errors/flux-exception"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).body("Your request is erroneous: Cannot process request.").build()));
    }

    @Test
    void testErrorHandlerWithFluxSingleResultThrownException() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/errors/flux-single-exception"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).body("Your request is erroneous: Cannot process request.").build()));
    }

    @Test
    void testErrorHandlerWithFluxChunkedSignaledImmediateError() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/errors/flux-chunked-immediate-error"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.INTERNAL_SERVER_ERROR).body("Internal Server Error: Cannot process request.").build()));
    }

    @Test
    void testErrorHandlerWithFluxChunkedSignaledDelayedError() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/errors/flux-chunked-delayed-error"), (server, request) -> {
            Executable e = () -> server.exchange(request);
            Assertions.assertThrows(HttpClientException.class, (Executable)e);
        });
    }

    @Test
    void testErrorHandlerWithFluxSingleResultSignaledError() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/errors/flux-single-error"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).body("Your request is erroneous: Cannot process request.").build()));
    }

    static class MyTestException
    extends RuntimeException {
        public MyTestException(String message) {
            super(message);
        }
    }

    @Requires(property="spec.name", value="ErrorHandlerFluxTest")
    @Controller(value="/errors")
    static class ErrorController {
        ErrorController() {
        }

        @Get(value="/flux-exception")
        Flux<String> fluxException() {
            throw new MyTestException("Cannot process request.");
        }

        @Get(value="/flux-single-exception")
        @SingleResult
        Flux<String> fluxSingleException() {
            throw new MyTestException("Cannot process request.");
        }

        @Get(value="/flux-single-error")
        @SingleResult
        Flux<String> fluxSingleError() {
            return Flux.error((Throwable)new MyTestException("Cannot process request."));
        }

        @Get(value="/flux-chunked-immediate-error")
        Flux<String> fluxChunkedImmediateError() {
            return Flux.error((Throwable)new MyTestException("Cannot process request."));
        }

        @Get(value="/flux-chunked-delayed-error")
        Flux<String> fluxChunkedDelayedError() {
            return Flux.just((Object[])new String[]{"1", "2", "3"}).handle((data, sink) -> {
                if (data.equals("3")) {
                    sink.error((Throwable)new MyTestException("Cannot process request."));
                } else {
                    sink.next(data);
                }
            });
        }

        @Error(global=true)
        public HttpResponse<String> handleMyTestException(HttpRequest<?> request, MyTestException exception) {
            String error = "Your request is erroneous: " + exception.getMessage();
            return HttpResponse.status((HttpStatus)HttpStatus.I_AM_A_TEAPOT, (String)"Bad request").body((Object)error);
        }
    }
}

