/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter.options;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionsFilterTest {
    private static final String SPEC_NAME = "OptionsFilterTest";

    @Test
    public void optionsByDefaultResponds405() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.OPTIONS((String)"/foo/bar")).assertion(AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED)).run();
    }

    @Test
    public void getTest() throws IOException {
        OptionsFilterTest.assertion(HttpRequest.GET((String)"/foo/bar"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).build()));
    }

    @Test
    public void optionsRoute() throws IOException {
        OptionsFilterTest.assertion(HttpRequest.OPTIONS((String)"/options/route"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).build()));
    }

    @Test
    public void postTest() throws IOException {
        OptionsFilterTest.assertion(HttpRequest.POST((String)"/foo/bar", Collections.emptyMap()), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).build()));
    }

    @Test
    public void optionsTest() throws IOException {
        OptionsFilterTest.assertion(HttpRequest.OPTIONS((String)"/foo/bar"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(httpResponse -> {
            Assertions.assertNotNull((Object)httpResponse.getHeaders().get((CharSequence)"Allow"));
            Assertions.assertNotNull((Object)httpResponse.getHeaders().getAll((CharSequence)"Allow"));
            Assertions.assertEquals((int)4, (int)httpResponse.getHeaders().getAll((CharSequence)"Allow").size());
            Assertions.assertTrue((boolean)httpResponse.getHeaders().getAll((CharSequence)"Allow").stream().anyMatch(v -> v.equals(HttpMethod.GET.toString())));
            Assertions.assertTrue((boolean)httpResponse.getHeaders().getAll((CharSequence)"Allow").stream().anyMatch(v -> v.equals(HttpMethod.POST.toString())));
            Assertions.assertTrue((boolean)httpResponse.getHeaders().getAll((CharSequence)"Allow").stream().anyMatch(v -> v.equals(HttpMethod.OPTIONS.toString())));
            Assertions.assertTrue((boolean)httpResponse.getHeaders().getAll((CharSequence)"Allow").stream().anyMatch(v -> v.equals(HttpMethod.HEAD.toString())));
        }).build()));
    }

    private static void assertion(HttpRequest<?> request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).configuration(Collections.singletonMap("micronaut.server.dispatch-options-requests", "true")).request(request).assertion(assertion).run();
    }

    @Controller
    @Requires(property="spec.name", value="OptionsFilterTest")
    public static class MyController {
        @Get(value="/foo/{id}")
        @Status(value=HttpStatus.OK)
        public void fooGet(String id) {
        }

        @Post(value="/foo/{id}")
        @Status(value=HttpStatus.CREATED)
        public void fooPost(String id) {
        }

        @Options(value="/options/route")
        @Status(value=HttpStatus.I_AM_A_TEAPOT)
        public void optionsRoute() {
        }
    }
}

