/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.forms;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormsSubmissionsWithListsTest {
    private static final String SPEC_NAME = "FormsSubmissionsWithListsTest";

    @Test
    public void formWithListOfOneItem() throws IOException {
        String body = "question=en+que+trabajas&usersId=1";
        String expectedJson = "{\"question\":\"en que trabajas\",\"usersId\":[1]}";
        FormsSubmissionsWithListsTest.assertWithBody(body, expectedJson);
    }

    @Test
    public void formWithListOfMoreThanOne() throws IOException {
        String body = "question=en+que+trabajas&usersId=1&usersId=2";
        String expectedJson = "{\"question\":\"en que trabajas\",\"usersId\":[1,2]}";
        FormsSubmissionsWithListsTest.assertWithBody(body, expectedJson);
    }

    private static void assertWithBody(String body, String expectedJson) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/questions/save", (Object)body).contentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(httpResponse -> {
            Optional bodyOptional = httpResponse.getBody(String.class);
            Assertions.assertTrue((boolean)bodyOptional.isPresent());
            Assertions.assertEquals((Object)expectedJson, bodyOptional.get());
        }).build())).run();
    }

    @Introspected
    public record QuestionSave(String question, List<Long> usersId) {
    }

    @Controller(value="/questions")
    @Requires(property="spec.name", value="FormsSubmissionsWithListsTest")
    public static class QuestionController {
        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/save")
        QuestionSave save(@Body QuestionSave questionSave) {
            return questionSave;
        }
    }
}

