/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.FilterContinuation;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.scheduling.annotation.ExecuteOn;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestFilterTest {
    public static final String SPEC_NAME = "RequestFilterTest";

    @Test
    public void requestFilterBinding() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/request-filter/binding", (Object)"{\"foo\":10}").contentType(MediaType.APPLICATION_JSON_TYPE)).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("application/json {\"foo\":10}").build());
            Assertions.assertEquals(List.of("binding application/json {\"foo\":10}"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterImmediateRequestParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/immediate-request-parameter")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("requestFilterImmediateRequestParameter /request-filter/immediate-request-parameter"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterImmediateMutableRequestParameter() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/immediate-mutable-request-parameter")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("bar").build())).run();
    }

    @Test
    public void requestFilterReplaceRequest() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-2").build())).run();
    }

    @Test
    public void requestFilterReplaceMutableRequest() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-mutable-request")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-mutable-request-2").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestNull() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-null")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-null").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestEmpty() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-empty")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-empty").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestPublisher() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-publisher")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-publisher-2").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestMono() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-mono")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-mono-2").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestCompletable() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-completable")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-completable-2").build())).run();
    }

    @Test
    public void requestFilterReplaceRequestCompletion() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/replace-request-completion")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/replace-request-completion-2").build())).run();
    }

    @Test
    public void requestFilterContinuationBlocking() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-blocking")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("bar").build());
            Assertions.assertEquals(List.of("requestFilterContinuationBlocking bar"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterContinuationReactivePublisher() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-reactive-publisher")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("bar").build());
            Assertions.assertEquals(List.of("requestFilterContinuationReactivePublisher bar"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterContinuationUpdateRequest() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-update-request")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("/request-filter/continuation-update-request-2").build())).run();
    }

    @Test
    public void requestFilterImmediateResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/immediate-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterImmediateResponse").build())).run();
    }

    @Test
    public void requestFilterNullResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/null-response")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("requestFilterNullResponse"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterEmptyOptionalResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/empty-optional-response")).assertion((server, request) -> {
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("foo").build());
            Assertions.assertEquals(List.of("requestFilterEmptyOptionalResponse"), ((MyServerFilter)server.getApplicationContext().getBean(MyServerFilter.class)).events);
        }).run();
    }

    @Test
    public void requestFilterPublisherResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/publisher-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterPublisherResponse").build())).run();
    }

    @Test
    public void requestFilterMonoResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/mono-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterMonoResponse").build())).run();
    }

    @Test
    public void requestFilterCompletableResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/completable-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterCompletableResponse").build())).run();
    }

    @Test
    public void requestFilterCompletionResponse() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/request-filter/completion-response")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("requestFilterCompletionResponse").build())).run();
    }

    @ServerFilter
    @Singleton
    @Requires(property="spec.name", value="RequestFilterTest")
    public static class MyServerFilter {
        List<String> events = new ArrayList<String>();

        @RequestFilter(value={"/request-filter/immediate-request-parameter"})
        public void requestFilterImmediateRequestParameter(HttpRequest<?> request) {
            this.events.add("requestFilterImmediateRequestParameter " + request.getPath());
        }

        @RequestFilter(value={"/request-filter/binding"})
        public void requestFilterBinding(@Header String contentType, @Body byte[] bytes, FilterContinuation<HttpResponse<?>> continuation) {
            this.events.add("binding " + contentType + " " + new String(bytes, StandardCharsets.UTF_8));
            continuation.proceed();
        }

        @RequestFilter(value={"/request-filter/immediate-mutable-request-parameter"})
        public void requestFilterImmediateMutableRequestParameter(MutableHttpRequest<?> request) {
            request.setAttribute((CharSequence)"foo", (Object)"bar");
        }

        @RequestFilter(value={"/request-filter/replace-request"})
        public HttpRequest<Object> requestFilterReplaceRequest() {
            return HttpRequest.GET((String)"/request-filter/replace-request-2");
        }

        @RequestFilter(value={"/request-filter/replace-mutable-request"})
        public MutableHttpRequest<Object> requestFilterReplaceMutableRequest() {
            return HttpRequest.GET((String)"/request-filter/replace-mutable-request-2");
        }

        @RequestFilter(value={"/request-filter/replace-request-null"})
        @Nullable
        public HttpRequest<Object> requestFilterReplaceRequestNull() {
            return null;
        }

        @RequestFilter(value={"/request-filter/replace-request-empty"})
        public Optional<HttpRequest<Object>> requestFilterReplaceRequestEmpty() {
            return Optional.empty();
        }

        @RequestFilter(value={"/request-filter/replace-request-publisher"})
        public Publisher<HttpRequest<Object>> requestFilterReplaceRequestPublisher() {
            return Flux.just((Object)HttpRequest.GET((String)"/request-filter/replace-request-publisher-2"));
        }

        @RequestFilter(value={"/request-filter/replace-request-mono"})
        public Mono<HttpRequest<Object>> requestFilterReplaceRequestMono() {
            return Mono.just((Object)HttpRequest.GET((String)"/request-filter/replace-request-mono-2"));
        }

        @RequestFilter(value={"/request-filter/replace-request-completable"})
        public CompletableFuture<HttpRequest<Object>> requestFilterReplaceRequestCompletable() {
            return CompletableFuture.completedFuture(HttpRequest.GET((String)"/request-filter/replace-request-completable-2"));
        }

        @RequestFilter(value={"/request-filter/replace-request-completion"})
        public CompletionStage<HttpRequest<Object>> requestFilterReplaceRequestCompletion() {
            return CompletableFuture.completedStage(HttpRequest.GET((String)"/request-filter/replace-request-completion-2"));
        }

        @RequestFilter(value={"/request-filter/continuation-blocking"})
        @ExecuteOn(value="blocking")
        public void requestFilterContinuationBlocking(HttpRequest<?> request, FilterContinuation<HttpResponse<?>> continuation) {
            request.setAttribute((CharSequence)"foo", (Object)"bar");
            HttpResponse r = (HttpResponse)continuation.proceed();
            this.events.add("requestFilterContinuationBlocking " + r.body());
        }

        @RequestFilter(value={"/request-filter/continuation-reactive-publisher"})
        public Publisher<HttpResponse<?>> requestFilterContinuationReactivePublisher(HttpRequest<?> request, FilterContinuation<Publisher<HttpResponse<?>>> continuation) {
            request.setAttribute((CharSequence)"foo", (Object)"bar");
            return Mono.from((Publisher)((Publisher)continuation.proceed())).doOnNext(r -> this.events.add("requestFilterContinuationReactivePublisher " + r.body()));
        }

        @RequestFilter(value={"/request-filter/continuation-update-request"})
        @ExecuteOn(value="blocking")
        public void requestFilterContinuationUpdateRequest(FilterContinuation<HttpResponse<?>> continuation) {
            continuation.request((HttpRequest)HttpRequest.GET((String)"/request-filter/continuation-update-request-2"));
            continuation.proceed();
        }

        @RequestFilter(value={"/request-filter/immediate-response"})
        public HttpResponse<?> requestFilterImmediateResponse() {
            return HttpResponse.ok((Object)"requestFilterImmediateResponse");
        }

        @RequestFilter(value={"/request-filter/null-response"})
        @Nullable
        public HttpResponse<?> requestFilterNullResponse() {
            this.events.add("requestFilterNullResponse");
            return null;
        }

        @RequestFilter(value={"/request-filter/empty-optional-response"})
        public Optional<HttpResponse<?>> requestFilterEmptyOptionalResponse() {
            this.events.add("requestFilterEmptyOptionalResponse");
            return Optional.empty();
        }

        @RequestFilter(value={"/request-filter/publisher-response"})
        public Publisher<HttpResponse<?>> requestFilterPublisherResponse() {
            return Mono.fromCallable(() -> HttpResponse.ok((Object)"requestFilterPublisherResponse"));
        }

        @RequestFilter(value={"/request-filter/mono-response"})
        public Mono<HttpResponse<?>> requestFilterMonoResponse() {
            return Mono.fromCallable(() -> HttpResponse.ok((Object)"requestFilterMonoResponse"));
        }

        @RequestFilter(value={"/request-filter/completable-response"})
        public CompletableFuture<MutableHttpResponse<String>> requestFilterCompletableResponse() {
            return CompletableFuture.completedFuture(HttpResponse.ok((Object)"requestFilterCompletableResponse"));
        }

        @RequestFilter(value={"/request-filter/completion-response"})
        public CompletionStage<MutableHttpResponse<String>> requestFilterCompletionResponse() {
            return CompletableFuture.completedStage(HttpResponse.ok((Object)"requestFilterCompletionResponse"));
        }
    }

    @Controller
    @Requires(property="spec.name", value="RequestFilterTest")
    public static class MyController {
        @Get(value="/request-filter/immediate-request-parameter")
        public String requestFilterImmediateRequestParameter() {
            return "foo";
        }

        @Get(value="/request-filter/immediate-mutable-request-parameter")
        public String requestFilterImmediateMutableRequestParameter(HttpRequest<?> request) {
            return request.getAttribute((CharSequence)"foo").get().toString();
        }

        @Get(value="/request-filter/replace-request")
        public String requestFilterReplaceRequest(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-mutable-request")
        public String requestFilterReplaceMutableRequest(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-null")
        public String requestFilterReplaceRequestNull(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-empty")
        public String requestFilterReplaceRequestEmpty(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-publisher")
        public String requestFilterReplaceRequestPublisher(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-mono")
        public String requestFilterReplaceRequestMono(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-completable")
        public String requestFilterReplaceRequestCompletable(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/replace-request-completion")
        public String requestFilterReplaceRequestCompletion(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/continuation-blocking")
        public String requestFilterContinuationBlocking(HttpRequest<?> request) {
            return request.getAttribute((CharSequence)"foo").get().toString();
        }

        @Get(value="/request-filter/continuation-reactive-publisher")
        public String requestFilterContinuationReactivePublisher(HttpRequest<?> request) {
            return request.getAttribute((CharSequence)"foo").get().toString();
        }

        @Get(value="/request-filter/continuation-update-request")
        public String requestFilterContinuationUpdateRequest(HttpRequest<?> request) {
            return request.getPath();
        }

        @Get(value="/request-filter/null-response")
        public String requestFilterNullResponse(HttpRequest<?> request) {
            return "foo";
        }

        @Get(value="/request-filter/empty-optional-response")
        public String requestFilterEmptyOptionalResponse(HttpRequest<?> request) {
            return "foo";
        }

        @Post(value="/request-filter/binding")
        public String requestFilterBinding(@Header String contentType, @Body byte[] bytes) {
            return contentType + " " + new String(bytes, StandardCharsets.UTF_8);
        }
    }
}

