/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeadersTest {
    public static final String SPEC_NAME = "HeadersTest";

    @Test
    void headersAreCaseInsensitiveAsPerMessageHeadersSpecification() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/foo/ok").header((CharSequence)"aCcEpT", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"status\":\"ok\"}").build()));
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/foo/bar").header((CharSequence)"fOO", (CharSequence)"ok"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"status\":\"okok\"}").build()));
    }

    @Test
    void multipleHeadersAreReceivedAsList() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/foo/receive-multiple-headers").header((CharSequence)"ETag", (CharSequence)"A").header((CharSequence)"ETag", (CharSequence)"B"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            Optional eTagsOptional = response.getBody(String.class);
            Assertions.assertTrue((boolean)eTagsOptional.isPresent());
            String json = (String)eTagsOptional.get();
            Assertions.assertTrue((json.equals("{\"headers\":[\"A\",\"B\"]}") || json.equals("{\"headers\":[\"A,B\"]}") ? 1 : 0) != 0);
        }).build()));
    }

    @Introspected
    record ETags(List<String> headers) {
    }

    @Controller(value="/foo")
    @Requires(property="spec.name", value="HeadersTest")
    static class ProduceController {
        ProduceController() {
        }

        @Get(value="/ok", produces={"application/json"})
        String getOkAsJson() {
            return "{\"status\":\"ok\"}";
        }

        @Get(value="/bar", produces={"application/json"})
        String getFooAsJson(@Header(value="Foo") String foo, @Header(value="fOo") String foo2) {
            return "{\"status\":\"" + foo + foo2 + "\"}";
        }

        @Get(value="/receive-multiple-headers")
        ETags receiveMultipleHeaders(HttpRequest<?> request) {
            return new ETags(request.getHeaders().getAll((CharSequence)"ETag"));
        }
    }
}

