/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Test;

public class RequestFilterExceptionHandlerTest {
    private static final String SPEC_NAME = "RequestFilterExceptionHandlerTest";

    @Test
    public void exceptionHandlerTest() throws IOException {
        RequestFilterExceptionHandlerTest.assertion(HttpRequest.GET((String)"/foo"), AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY));
    }

    private static void assertion(HttpRequest<?> request, BiConsumer<ServerUnderTest, HttpRequest<?>> assertion) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request(request).assertion(assertion).run();
    }

    @Requires(property="spec.name", value="RequestFilterExceptionHandlerTest")
    @Singleton
    static class FooExceptionHandler
    implements ExceptionHandler<FooException, HttpResponse<?>> {
        private final ErrorResponseProcessor<?> errorResponseProcessor;

        public FooExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor) {
            this.errorResponseProcessor = errorResponseProcessor;
        }

        public HttpResponse<?> handle(HttpRequest request, FooException exception) {
            return this.errorResponseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)exception).build(), HttpResponse.unprocessableEntity());
        }
    }

    @Requires(property="spec.name", value="RequestFilterExceptionHandlerTest")
    @Controller(value="/foo")
    static class FooController {
        FooController() {
        }

        @Produces(value={"text/plain"})
        @Get
        String index() {
            return "Hello World";
        }
    }

    @ServerFilter(value={"/**"})
    @Requires(property="spec.name", value="RequestFilterExceptionHandlerTest")
    static class ErrorThrowingFilter {
        ErrorThrowingFilter() {
        }

        @RequestFilter
        public void doFilter(MutableHttpRequest<?> request) {
            throw new FooException();
        }
    }

    static class FooException
    extends RuntimeException {
        FooException() {
        }
    }
}

