/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.exceptions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class HtmlErrorPageTest {
    private static final String SPEC_NAME = "HtmlErrorPageTest";

    @Test
    void htmlErrorPage() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/book/save", (Object)new Book("Building Microservices", "", 5000)).accept(new CharSequence[]{"text/html"}), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).body(BodyAssertion.builder().body("<!doctype html>").contains()).body(BodyAssertion.builder().body("book.author: must not be blank").contains()).body(BodyAssertion.builder().body("book.pages: must be less than or equal to 4032").contains()).headers(Map.of("Content-Type", "text/html")).build()));
    }

    @Introspected
    record Book(@NotBlank String title, @NotBlank String author, @Max(value=4032L) @Max(value=4032L) int pages) {
    }

    @Requires(property="spec.name", value="HtmlErrorPageTest")
    @Controller(value="/book")
    static class FooController {
        FooController() {
        }

        @Produces(value={"text/html"})
        @Post(value="/save")
        @Status(value=HttpStatus.CREATED)
        void save(@Body @Valid Book book) {
            throw new UnsupportedOperationException();
        }
    }
}

