/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.NotAllowedException;
import io.micronaut.http.server.exceptions.NotAllowedExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ErrorNotFoundRouteExceptionHandlerTest {
    public static final String SPEC_NAME = "ErrorNotFoundRouteExceptionHandlerTest";

    @Test
    void testCatchingRouteNotFoundExceptions() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/no-existing"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("IT'S FINE: Method [GET] not allowed for URI [/no-existing]. Allowed methods: [POST]").equals()).headers(Map.of("Content-Type", "text/plain")).build()));
    }

    @Requires(property="spec.name", value="ErrorNotFoundRouteExceptionHandlerTest")
    @Produces(value={"text/plain"})
    @Singleton
    @Primary
    static class MyExceptionHandler
    extends NotAllowedExceptionHandler {
        public MyExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
            super(responseProcessor);
        }

        public HttpResponse<?> handle(HttpRequest request, NotAllowedException exception) {
            return HttpResponse.ok((Object)("IT'S FINE: " + exception.getMessage()));
        }
    }

    @Requires(property="spec.name", value="ErrorNotFoundRouteExceptionHandlerTest")
    @Controller(value="/no-existing")
    static class ExceptionController {
        ExceptionController() {
        }

        @Post
        String simplePost() {
            return "Hello";
        }
    }
}

