/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;

public class RemoteAddressTest {
    public static final String SPEC_NAME = "RemoteAddressTest";

    @Test
    void testRemoteAddressComesFromIdentitySourceIp() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/remoteAddress/fromSourceIp"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).headers(Collections.singletonMap("X-Captured-Remote-Address", "127.0.0.1")).build()));
    }

    @Requires(property="spec.name", value="RemoteAddressTest")
    @Produces
    @Singleton
    static class CustomExceptionHandler
    implements ExceptionHandler<Exception, HttpResponse> {
        CustomExceptionHandler() {
        }

        public HttpResponse handle(HttpRequest request, Exception exception) {
            return HttpResponse.serverError((Object)exception.toString());
        }
    }

    @Requires(property="spec.name", value="RemoteAddressTest")
    @Filter(value={"/remoteAddress/**"})
    static class CaptureRemoteAddressFiter
    implements HttpServerFilter {
        CaptureRemoteAddressFiter() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            return Publishers.map((Publisher)chain.proceed(request), httpResponse -> {
                httpResponse.getHeaders().add((CharSequence)"X-Captured-Remote-Address", (CharSequence)request.getRemoteAddress().getAddress().getHostAddress());
                return httpResponse;
            });
        }
    }

    @Requires(property="spec.name", value="RemoteAddressTest")
    @Controller(value="/remoteAddress")
    static class TestController {
        TestController() {
        }

        @Get(value="fromSourceIp")
        void sourceIp() {
        }
    }
}

