/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.jsonview;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

class JsonViewsTest {
    public static final String SPEC_NAME = "JsonViewsTest";
    private static final Map<String, Object> CONFIGURATION = Map.of("jackson.json-view.enabled", true);

    JsonViewsTest() {
    }

    @Test
    void testJsonViewPojo() throws Exception {
        this.assertPath("/views/pojo");
    }

    @Test
    void testJsonViewList() throws Exception {
        this.assertPath("/views/list");
    }

    @Test
    void testJsonViewOptional() throws Exception {
        this.assertPath("/views/optional");
    }

    @Test
    void testJsonViewMono() throws Exception {
        this.assertPath("/views/mono");
    }

    @Test
    void testJsonViewFlux() throws Exception {
        this.assertPath("/views/flux");
    }

    @Test
    void testJsonViewFuture() throws Exception {
        this.assertPath("/views/future");
    }

    private void assertPath(String path) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, CONFIGURATION, (HttpRequest)HttpRequest.GET((String)path), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().body(BodyAssertion.builder().body("password").doesntContain()).status(HttpStatus.OK).build()));
    }
}

