/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class MissingBodyAnnotationTest {
    public static final String SPEC_NAME = "MissingBodyAnnotationTest";

    @Disabled(value="Since Micronaut Framework the @Body annotation is required.")
    @Test
    void testBodyAnnotationMissing() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/missing-body-annotation-test/absent", (Object)new Dto("tim")), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("tim").build()));
    }

    @Test
    void testBodyAnnotationPresent() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/missing-body-annotation-test/present", (Object)new Dto("tim")), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("tim").build()));
    }

    @Introspected
    static class Dto {
        private final String value;

        public Dto(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @Controller(value="/missing-body-annotation-test")
    @Requires(property="spec.name", value="MissingBodyAnnotationTest")
    static class BodyController {
        BodyController() {
        }

        @Post(value="/absent")
        String absent(Dto dto) {
            return dto.getValue();
        }

        @Post(value="/present")
        String present(@Body Dto dto) {
            return dto.getValue();
        }
    }
}

