/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.binding;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.time.LocalDateTime;
import org.junit.jupiter.api.Test;

public class LocalDateTimeTest {
    public static final String SPEC_NAME = "ControllerConstraintHandlerTest";

    @Test
    void getQueryValueWithLocalDateTimeWithoutSeconds() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/localdatetime/get?eventDate=2023-10-28T10%3A00"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"eventDate\":\"2023-10-28T10:00\"}").equals()).build()));
    }

    @Test
    void getQueryValueWithLocalDateTimeWithSeconds() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/localdatetime/get?eventDate=2023-10-28T10%3A20%3A23"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"eventDate\":\"2023-10-28T10:20:23\"}").equals()).build()));
    }

    @Test
    void formUrlEncodedPostWithLocalDateTimeWithoutSeconds() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/localdatetime/save", (Object)"eventDate=2023-10-28T10%3A00").contentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"eventDate\":\"2023-10-28T10:00\"}").equals()).build()));
    }

    @Test
    void formUrlEncodedPostWithLocalDateTimeWithSeconds() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/localdatetime/save/seconds", (Object)"eventDate=2023-10-28T10%3A20%3A23").contentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"eventDate\":\"2023-10-28T10:20:23\"}").equals()).build()));
    }

    @Introspected
    public static class Event {
        private final LocalDateTime eventDate;

        public Event(LocalDateTime eventDate) {
            this.eventDate = eventDate;
        }

        public LocalDateTime getEventDate() {
            return this.eventDate;
        }
    }

    @Requires(property="spec.name", value="ControllerConstraintHandlerTest")
    @Controller(value="/localdatetime")
    static class SaveController {
        SaveController() {
        }

        @Get(value="/get{?eventDate")
        String get(@QueryValue LocalDateTime eventDate) {
            return "{\"eventDate\":\"" + eventDate.toString() + "\"}";
        }

        @Get(value="/get/seconds{?eventDate")
        String getSeconds(@QueryValue LocalDateTime eventDate) {
            return "{\"eventDate\":\"" + eventDate.toString() + "\"}";
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/save")
        String save(@Body Event event) {
            return "{\"eventDate\":\"" + event.getEventDate().toString() + "\"}";
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/save/seconds")
        String saveSeconds(@Body Event event) {
            return "{\"eventDate\":\"" + event.getEventDate().toString() + "\"}";
        }
    }
}

