/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class NoBodyResponseTest {
    public static final String SPEC_NAME = "MissingBodyTest";
    private final Map<String, Object> disableNotFoundOnMissingBodyConf = Map.of("micronaut.server.not-found-on-missing-body", "false");

    @Test
    void getPojoStatus() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-status"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoStatusDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-status"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojo() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NO_CONTENT).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojoStatusFuture() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-status-future"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoStatusFutureDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-status-future"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojoFuture() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-future"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoFutureDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-future"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NO_CONTENT).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojoFutureResponse() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-future-response"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoFutureResponseDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-future-response"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojoStatusPublisher() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-status-publisher"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoStatusPublisherDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-status-publisher"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojoPublisher() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-publisher"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoPublisherDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-publisher"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NO_CONTENT).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void getPojoPublisherResponse() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-publisher-response"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void getPojoPublisherResponseDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.GET((String)"/response-no-body/get-pojo-publisher-response"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void postReturnsPojoStatus() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-no-body/post-returns-pojo-status", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void postReturnsPojoStatusDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.POST((String)"/response-no-body/post-returns-pojo-status", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void postReturnsPojo() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-no-body/post-returns-pojo", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void postReturnsPojoDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.POST((String)"/response-no-body/post-returns-pojo", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NO_CONTENT).body(BodyAssertion.IS_MISSING).build()));
    }

    @Test
    void postReturnsResponsePojo() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-no-body/post-returns-response-pojo", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertThrowsStatus((HttpStatus)HttpStatus.NOT_FOUND));
    }

    @Test
    void postReturnsResponsePojoDisabled() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, this.disableNotFoundOnMissingBodyConf, (HttpRequest)HttpRequest.POST((String)"/response-no-body/post-returns-response-pojo", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.IS_MISSING).build()));
    }

    @Introspected
    static class Point {
        private Integer x;
        private Integer y;

        public Point(Integer x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public Integer getX() {
            return this.x;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public Integer getY() {
            return this.y;
        }

        public void setY(Integer y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            if (!Objects.equals(this.x, point.x)) {
                return false;
            }
            return Objects.equals(this.y, point.y);
        }

        public int hashCode() {
            int result = this.x != null ? this.x.hashCode() : 0;
            result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
            return result;
        }
    }

    @Controller(value="/response-no-body")
    @Requires(property="spec.name", value="MissingBodyTest")
    static class BodyController {
        BodyController() {
        }

        @Get(value="/get-pojo-status")
        @Status(value=HttpStatus.CREATED)
        Point getPojoStatus() {
            return null;
        }

        @Get(value="/get-pojo")
        Point getPojo() {
            return null;
        }

        @Get(value="/get-pojo-status-future")
        @Status(value=HttpStatus.CREATED)
        CompletableFuture<Point> getPojoStatusFuture() {
            return CompletableFuture.completedFuture(null);
        }

        @Get(value="/get-pojo-future")
        CompletableFuture<Point> getPojoFuture() {
            return CompletableFuture.completedFuture(null);
        }

        @Get(value="/get-pojo-future-response")
        CompletableFuture<HttpResponse<Point>> getPojoFutureResponse() {
            return CompletableFuture.completedFuture(HttpResponse.ok());
        }

        @SingleResult
        @Get(value="/get-pojo-status-publisher")
        @Status(value=HttpStatus.CREATED)
        Publisher<Point> getPojoStatusPublisher() {
            return Mono.empty();
        }

        @SingleResult
        @Get(value="/get-pojo-publisher")
        Publisher<Point> getPojoFuturePublisher() {
            return Mono.empty();
        }

        @Get(value="/get-pojo-publisher-response")
        Publisher<HttpResponse<Point>> getPojoFuturePublisherResponse() {
            return Mono.just((Object)HttpResponse.ok());
        }

        @Post(uri="/post-returns-pojo-status")
        @Status(value=HttpStatus.CREATED)
        Point postBodyReturnsPojo(@Body Point data) {
            return null;
        }

        @Post(uri="/post-returns-pojo")
        Point postNoBodyReturnsPojo() {
            return null;
        }

        @Post(uri="/post-returns-response-pojo")
        HttpResponse<Point> postBodyReturnsPojoResponse(@Body Point data) {
            return HttpResponse.ok();
        }
    }
}

