/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.jsonview;

import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.server.tck.tests.jsonview.User;
import io.micronaut.http.server.tck.tests.jsonview.Views;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requires(property="spec.name", value="JsonViewsTest")
@Controller(value="/views")
class UserController {
    private static final User USER = new User(1, "Joe", "secret");

    UserController() {
    }

    @JsonView(value={Views.Public.class})
    @Get(value="/pojo")
    public User getUserPojo() {
        return USER;
    }

    @JsonView(value={Views.Public.class})
    @Get(value="/list")
    public List<User> getUserList() {
        return List.of(USER);
    }

    @JsonView(value={Views.Public.class})
    @Get(value="/optional")
    public Optional<User> getUserOptional() {
        return Optional.of(USER);
    }

    @JsonView(value={Views.Public.class})
    @Get(value="/future")
    public CompletableFuture<User> getUserFuture() {
        return CompletableFuture.completedFuture(USER);
    }

    @JsonView(value={Views.Public.class})
    @Get(value="/mono")
    public Mono<User> getUserMono() {
        return Mono.just((Object)USER);
    }

    @JsonView(value={Views.Public.class})
    @Get(value="/flux")
    public Flux<User> getUserFlux() {
        return Flux.just((Object)USER);
    }
}

