/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.exceptions.NotAllowedException;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ErrorNotFoundRouteErrorRouteTest {
    public static final String SPEC_NAME = "ErrorNotFoundRouteErrorRouteTest";

    @Test
    void testCatchingRouteNotFoundExceptions() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/no-existing"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("IT'S FINE: Method [GET] not allowed for URI [/no-existing]. Allowed methods: [POST]").equals()).headers(Map.of("Content-Type", "text/plain")).build()));
    }

    @Requires(property="spec.name", value="ErrorNotFoundRouteErrorRouteTest")
    @Controller(value="/no-existing")
    static class ExceptionController {
        ExceptionController() {
        }

        @Post
        String simplePost() {
            return "Hello";
        }

        @Error
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        String localHandler(NotAllowedException throwable) {
            return "IT'S FINE: " + throwable.getMessage();
        }
    }
}

