/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.forms;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.scheduling.annotation.ExecuteOn;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UploadTest {
    private static final String SPEC_NAME = "UploadTest";

    @Test
    public void inputStream() throws Exception {
        Path tmp = Files.createTempFile(SPEC_NAME, ".txt", new FileAttribute[0]);
        try {
            Files.writeString(tmp, (CharSequence)"foo", new OpenOption[0]);
            TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/upload/input-stream", (Object)MultipartBody.builder().addPart("file", tmp.toFile()).build()).contentType((CharSequence)"multipart/form-data")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(httpResponse -> {
                Optional bodyOptional = httpResponse.getBody(String.class);
                Assertions.assertTrue((boolean)bodyOptional.isPresent());
                Assertions.assertEquals((Object)"foo", bodyOptional.get());
            }).build())).run();
        }
        finally {
            Files.deleteIfExists(tmp);
        }
    }

    @Controller(value="/upload")
    @Requires(property="spec.name", value="UploadTest")
    public static class UploadController {
        @Consumes(value={"multipart/form-data"})
        @Post(value="/input-stream")
        @ExecuteOn(value="blocking")
        byte[] inputStream(StreamingFileUpload file) throws Exception {
            try (InputStream stream = file.asInputStream();){
                byte[] byArray = stream.readAllBytes();
                return byArray;
            }
        }
    }
}

