/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.hateoas;

import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.hateoas.GenericResource;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class JsonErrorTest {
    private static final String SPEC_NAME = "JsonErrorTest";

    @Test
    public void responseCanBeBoundToJsonError() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/jsonError"), (server, request) -> {
            Executable e = () -> server.exchange(request, JsonError.class);
            HttpClientResponseException ex = (HttpClientResponseException)Assertions.assertThrows(HttpClientResponseException.class, (Executable)e);
            Optional jsonErrorOptional = ex.getResponse().getBody(JsonError.class);
            Assertions.assertTrue((boolean)jsonErrorOptional.isPresent());
            JsonError jsonError = (JsonError)jsonErrorOptional.get();
            Assertions.assertEquals((Object)"Not Found", (Object)jsonError.getMessage());
            OptionalMultiValues links = jsonError.getLinks();
            Assertions.assertFalse((boolean)links.isEmpty());
            links.getFirst((CharSequence)"self").ifPresent(link -> {
                Assertions.assertEquals((Object)"/jsonError", (Object)link.getHref());
                Assertions.assertFalse((boolean)link.isTemplated());
            });
            OptionalMultiValues resourceOptionalMultiValues = jsonError.getEmbedded();
            Assertions.assertFalse((boolean)resourceOptionalMultiValues.isEmpty());
            Optional errorsOptional = resourceOptionalMultiValues.get((CharSequence)"errors");
            Assertions.assertTrue((boolean)errorsOptional.isPresent());
            List resources = (List)errorsOptional.get();
            Optional<GenericResource> genericResourceOptional = resources.stream().filter(resource -> resource instanceof GenericResource).map(GenericResource.class::cast).findFirst();
            Assertions.assertTrue((boolean)genericResourceOptional.isPresent());
            Assertions.assertEquals((Object)"Page Not Found", genericResourceOptional.get().getAdditionalProperties().get("message"));
        });
    }
}

