/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.endpoints.health;

import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.json.JsonMapper;
import io.micronaut.management.health.indicator.HealthResult;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Test;

public class HealthResultTest {
    private static final String SPEC_NAME = "HealthResultTest";

    @Test
    public void healthResultSerialization() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/healthresult"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"name\":\"db\",\"status\":\"DOWN\",\"details\":{\"foo\":\"bar\"}}").build()));
    }

    @Controller(value="/healthresult")
    @Requires(property="spec.name", value="HealthResultTest")
    public static class QuestionController {
        private final JsonMapper jsonMapper;

        public QuestionController(JsonMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Get
        String index() throws IOException {
            return this.jsonMapper.writeValueAsString((Object)HealthResult.builder((String)"db", (HealthStatus)HealthStatus.DOWN).details(Collections.singletonMap("foo", "bar")).build());
        }
    }
}

