/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.cachecontrol.CacheControl;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CacheControlTest {
    public static final String SPEC_NAME = "CacheControlTest";
    private static final HttpResponseAssertion ASSERTION = HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
        Assertions.assertTrue((boolean)response.getHeaders().get((CharSequence)"Cache-Control", String.class).isPresent());
        Assertions.assertEquals((Object)"public, max-age=31536000, immutable", (Object)response.getHeaders().get((CharSequence)"Cache-Control"));
    }).build();

    @Test
    void canPopulateCacheControlHttpHeaderInResponse() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/assets/bootstrap-5.3.3-dist/css/bootstrap.css").accept(new CharSequence[]{"text/css"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Requires(property="spec.name", value="CacheControlTest")
    @ServerFilter(patternStyle=FilterPatternStyle.REGEX, value={"/assets/bootstrap.*"})
    static class PublicInmmutableCacheControlFilter {
        PublicInmmutableCacheControlFilter() {
        }

        @ResponseFilter
        void filterResponse(MutableHttpResponse<?> rsp) {
            if (!rsp.getHeaders().contains("Cache-Control")) {
                rsp.cacheControl(CacheControl.builder().publicDirective().maxAge(Duration.ofDays(365L)).inmutable().build());
            }
        }
    }

    @Requires(property="spec.name", value="CacheControlTest")
    @Controller
    static class BootstrapController {
        BootstrapController() {
        }

        @Produces(value={"text/css"})
        @Get(value="/assets/bootstrap-5.3.3-dist/css/bootstrap.css")
        String index() {
            return "*,\n*::before,\n*::after {\n  box-sizing: border-box;\n";
        }
    }
}

