/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import io.micronaut.http.server.cors.CorsUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

@Filter(value={"/**"})
public class CorsFilter
implements HttpServerFilter {
    protected final HttpServerConfiguration.CorsConfiguration corsConfiguration;

    public CorsFilter(HttpServerConfiguration.CorsConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        boolean originHeaderPresent = request.getHeaders().getOrigin().isPresent();
        if (originHeaderPresent) {
            Optional<MutableHttpResponse<?>> response = this.handleRequest(request);
            if (response.isPresent()) {
                return Publishers.just(response.get());
            }
            return Publishers.map((Publisher)chain.proceed(request), mutableHttpResponse -> {
                this.handleResponse(request, (MutableHttpResponse<?>)mutableHttpResponse);
                return mutableHttpResponse;
            });
        }
        return chain.proceed(request);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected void handleResponse(HttpRequest<?> request, MutableHttpResponse<?> response) {
        HttpHeaders headers = request.getHeaders();
        Optional originHeader = headers.getOrigin();
        originHeader.ifPresent(requestOrigin -> {
            Optional<CorsOriginConfiguration> optionalConfig = this.getConfiguration((String)requestOrigin);
            if (optionalConfig.isPresent()) {
                CorsOriginConfiguration config = optionalConfig.get();
                if (CorsUtil.isPreflightRequest(request)) {
                    Optional result = headers.getFirst((CharSequence)"Access-Control-Request-Method", HttpMethod.class);
                    this.setAllowMethods((HttpMethod)result.get(), response);
                    Optional allowedHeaders = headers.get((CharSequence)"Access-Control-Request-Headers", Argument.of(List.class, (Class[])new Class[]{String.class}));
                    allowedHeaders.ifPresent(val -> this.setAllowHeaders((List<?>)val, response));
                    this.setMaxAge(config.getMaxAge(), response);
                }
                this.setOrigin((String)requestOrigin, (MutableHttpResponse)response);
                this.setVary(response);
                this.setExposeHeaders(config.getExposedHeaders(), response);
                this.setAllowCredentials(config, response);
            }
        });
    }

    protected Optional<MutableHttpResponse<?>> handleRequest(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        Optional originHeader = headers.getOrigin();
        if (originHeader.isPresent()) {
            String requestOrigin = (String)originHeader.get();
            boolean preflight = CorsUtil.isPreflightRequest(request);
            Optional<CorsOriginConfiguration> optionalConfig = this.getConfiguration(requestOrigin);
            if (optionalConfig.isPresent()) {
                CorsOriginConfiguration config = optionalConfig.get();
                HttpMethod requestMethod = request.getMethod();
                List<HttpMethod> allowedMethods = config.getAllowedMethods();
                if (!this.isAnyMethod(allowedMethods)) {
                    HttpMethod methodToMatch;
                    HttpMethod httpMethod = methodToMatch = preflight ? headers.getFirst((CharSequence)"Access-Control-Request-Method", HttpMethod.class).orElse(requestMethod) : requestMethod;
                    if (allowedMethods.stream().noneMatch(method -> method.equals((Object)methodToMatch))) {
                        return Optional.of(HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN));
                    }
                }
                if (preflight) {
                    Optional accessControlHeaders = headers.get((CharSequence)"Access-Control-Request-Headers", Argument.listOf(String.class));
                    List<String> allowedHeaders = config.getAllowedHeaders();
                    if (!this.isAny(allowedHeaders) && accessControlHeaders.isPresent() && !((List)accessControlHeaders.get()).stream().allMatch(header -> allowedHeaders.stream().anyMatch(allowedHeader -> allowedHeader.equals(header.trim())))) {
                        return Optional.of(HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN));
                    }
                    MutableHttpResponse ok = HttpResponse.ok();
                    this.handleResponse(request, ok);
                    return Optional.of(ok);
                }
            }
        }
        return Optional.empty();
    }

    protected void setAllowCredentials(CorsOriginConfiguration config, MutableHttpResponse<?> response) {
        if (config.isAllowCredentials()) {
            response.header((CharSequence)"Access-Control-Allow-Credentials", (CharSequence)Boolean.toString(true));
        }
    }

    protected void setExposeHeaders(List<String> exposedHeaders, MutableHttpResponse<?> response) {
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", exposedHeaders);
            if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
                response.header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)headerValue);
            }
        } else {
            exposedHeaders.forEach(header -> response.header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)header));
        }
    }

    protected void setVary(MutableHttpResponse<?> response) {
        response.header((CharSequence)"Vary", (CharSequence)"Origin");
    }

    protected void setOrigin(String origin, MutableHttpResponse response) {
        response.header((CharSequence)"Access-Control-Allow-Origin", (CharSequence)origin);
    }

    protected void setAllowMethods(HttpMethod method, MutableHttpResponse response) {
        response.header((CharSequence)"Access-Control-Allow-Methods", (CharSequence)method);
    }

    protected void setAllowHeaders(List<?> optionalAllowHeaders, MutableHttpResponse response) {
        List<String> allowHeaders = optionalAllowHeaders.stream().map(Object::toString).collect(Collectors.toList());
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", allowHeaders);
            if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
                response.header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)headerValue);
            }
        } else {
            allowHeaders.forEach(header -> response.header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)header));
        }
    }

    protected void setMaxAge(long maxAge, MutableHttpResponse response) {
        if (maxAge > -1L) {
            response.header((CharSequence)"Access-Control-Max-Age", (CharSequence)Long.toString(maxAge));
        }
    }

    private Optional<CorsOriginConfiguration> getConfiguration(String requestOrigin) {
        Map<String, CorsOriginConfiguration> corsConfigurations = this.corsConfiguration.getConfigurations();
        for (Map.Entry<String, CorsOriginConfiguration> config : corsConfigurations.entrySet()) {
            List<String> allowedOrigins = config.getValue().getAllowedOrigins();
            if (allowedOrigins.isEmpty()) continue;
            boolean matches = false;
            if (this.isAny(allowedOrigins)) {
                matches = true;
            }
            if (!matches) {
                matches = allowedOrigins.stream().anyMatch(origin -> {
                    if (origin.equals(requestOrigin)) {
                        return true;
                    }
                    Pattern p = Pattern.compile(origin);
                    Matcher m = p.matcher(requestOrigin);
                    return m.matches();
                });
            }
            if (!matches) continue;
            return Optional.of(config.getValue());
        }
        return Optional.empty();
    }

    private boolean isAny(List<String> values) {
        return values == CorsOriginConfiguration.ANY;
    }

    private boolean isAnyMethod(List<HttpMethod> allowedMethods) {
        return allowedMethods == CorsOriginConfiguration.ANY_METHOD;
    }
}

