/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.codec;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.sse.Event;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
@Internal
@BootstrapContextCompatible
public class TextStreamCodec
implements MediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "text-stream";
    private static final byte[] DATA_PREFIX = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENT_PREFIX = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ID_PREFIX = "id: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RETRY_PREFIX = "retry: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMENT_PREFIX = ": ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private final Provider<MediaTypeCodecRegistry> codecRegistryProvider;
    private final ByteBufferFactory byteBufferFactory;
    private final List<MediaType> additionalTypes;
    private final Charset defaultCharset;
    private MediaTypeCodecRegistry codecRegistry;

    @Deprecated
    public TextStreamCodec(HttpServerConfiguration serverConfiguration, ByteBufferFactory byteBufferFactory, Provider<MediaTypeCodecRegistry> codecRegistryProvider, @Named(value="text-stream") @Nullable CodecConfiguration codecConfiguration) {
        this(serverConfiguration.getDefaultCharset(), byteBufferFactory, codecRegistryProvider, codecConfiguration);
    }

    @Inject
    public TextStreamCodec(ApplicationConfiguration applicationConfiguration, ByteBufferFactory byteBufferFactory, Provider<MediaTypeCodecRegistry> codecRegistryProvider, @Named(value="text-stream") @Nullable CodecConfiguration codecConfiguration) {
        this(applicationConfiguration.getDefaultCharset(), byteBufferFactory, codecRegistryProvider, codecConfiguration);
    }

    protected TextStreamCodec(Charset defaultCharset, ByteBufferFactory byteBufferFactory, Provider<MediaTypeCodecRegistry> codecRegistryProvider, @Named(value="text-stream") @Nullable CodecConfiguration codecConfiguration) {
        this.defaultCharset = defaultCharset;
        this.byteBufferFactory = byteBufferFactory;
        this.codecRegistryProvider = codecRegistryProvider;
        this.additionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.TEXT_EVENT_STREAM_TYPE);
        mediaTypes.addAll(this.additionalTypes);
        return mediaTypes;
    }

    public <T> T decode(Argument<T> type, InputStream inputStream) throws CodecException {
        throw new UnsupportedOperationException("This codec currently only supports encoding");
    }

    public <T> T decode(Class<T> type, InputStream inputStream) throws CodecException {
        throw new UnsupportedOperationException("This codec currently only supports encoding");
    }

    public <T> void encode(T object, OutputStream outputStream) throws CodecException {
        try {
            outputStream.write(this.encode(object));
        }
        catch (IOException e) {
            throw new CodecException("I/O error occurred encoding object to output stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> byte[] encode(T object) throws CodecException {
        ByteBuffer buffer = this.encode(object, this.byteBufferFactory);
        return buffer.toByteArray();
    }

    public <T> ByteBuffer encode(T object, ByteBufferFactory allocator) throws CodecException {
        byte[] line;
        int length;
        ByteBuffer body;
        Event event = object instanceof Event ? (Event)object : Event.of(object);
        Object data = event.getData();
        if (data instanceof CharSequence) {
            body = allocator.copiedBuffer(data.toString().getBytes(this.defaultCharset));
        } else {
            MediaTypeCodec jsonCodec = (MediaTypeCodec)this.resolveMediaTypeCodecRegistry().findCodec(MediaType.APPLICATION_JSON_TYPE).orElseThrow(() -> new CodecException("No possible JSON encoders found!"));
            body = jsonCodec.encode(data, allocator);
        }
        ByteBuffer eventData = allocator.buffer(body.readableBytes() + 10);
        this.writeAttribute(eventData, COMMENT_PREFIX, event.getComment());
        this.writeAttribute(eventData, ID_PREFIX, event.getId());
        this.writeAttribute(eventData, EVENT_PREFIX, event.getName());
        Duration retry = event.getRetry();
        if (retry != null) {
            this.writeAttribute(eventData, RETRY_PREFIX, String.valueOf(retry.toMillis()));
        }
        int idx = body.indexOf((byte)10);
        while (idx > -1) {
            length = idx + 1;
            line = new byte[length];
            body.read(line, 0, length);
            eventData.write(DATA_PREFIX).write(line);
            idx = body.indexOf((byte)10);
        }
        if (body.readableBytes() > 0) {
            length = body.readableBytes();
            line = new byte[length];
            body.read(line, 0, length);
            eventData.write(DATA_PREFIX).write(line);
        }
        eventData.write(NEWLINE).write(NEWLINE);
        return eventData;
    }

    private MediaTypeCodecRegistry resolveMediaTypeCodecRegistry() {
        if (this.codecRegistry == null) {
            this.codecRegistry = (MediaTypeCodecRegistry)this.codecRegistryProvider.get();
        }
        return this.codecRegistry;
    }

    protected void writeAttribute(ByteBuffer eventData, byte[] attribute, String value) {
        if (value != null) {
            eventData.write(attribute).write((CharSequence)value, this.defaultCharset).write(NEWLINE);
        }
    }
}

