/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Produces
public class ContentLengthExceededHandler
implements ExceptionHandler<ContentLengthExceededException, HttpResponse> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public ContentLengthExceededHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public ContentLengthExceededHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public HttpResponse handle(HttpRequest request, ContentLengthExceededException exception) {
        MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.REQUEST_ENTITY_TOO_LARGE);
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder(request).cause((Throwable)exception).errorMessage(exception.getMessage()).build(), response);
        }
        return response.body((Object)new JsonError(exception.getMessage()).link(Link.SELF, Link.of((URI)request.getUri())));
    }
}

