/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util.locale;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.locale.HttpAbstractLocaleResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolutionConfiguration;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(property="micronaut.server.locale-resolution.cookie-name")
public class CookieLocaleResolver
extends HttpAbstractLocaleResolver {
    private final String cookieName;

    public CookieLocaleResolver(HttpLocaleResolutionConfiguration httpLocaleResolutionConfiguration) {
        super(httpLocaleResolutionConfiguration);
        this.cookieName = httpLocaleResolutionConfiguration.getCookieName().orElseThrow(() -> new IllegalArgumentException("The locale cookie name must be set"));
    }

    @NonNull
    public Optional<Locale> resolve(@NonNull HttpRequest<?> request) {
        return request.getCookies().get((CharSequence)this.cookieName, Locale.class);
    }
}

