/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.json.JsonConfiguration;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;

@Singleton
@Secondary
public class HateoasErrorResponseProcessor
implements ErrorResponseProcessor<JsonError> {
    private final boolean alwaysSerializeErrorsAsList;

    public HateoasErrorResponseProcessor(JsonConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    public HateoasErrorResponseProcessor(JacksonConfiguration jacksonConfiguration) {
        this((JsonConfiguration)jacksonConfiguration);
    }

    @Override
    @NonNull
    public MutableHttpResponse<JsonError> processResponse(@NonNull ErrorContext errorContext, @NonNull MutableHttpResponse<?> response) {
        JsonError error;
        if (!errorContext.hasErrors()) {
            error = new JsonError(response.getStatus().getReason());
        } else if (errorContext.getErrors().size() == 1 && !this.alwaysSerializeErrorsAsList) {
            Error jsonError = errorContext.getErrors().get(0);
            error = new JsonError(jsonError.getMessage());
            jsonError.getPath().ifPresent(arg_0 -> ((JsonError)error).path(arg_0));
        } else {
            error = new JsonError(response.getStatus().getReason());
            ArrayList<JsonError> errors = new ArrayList<JsonError>();
            for (Error jsonError : errorContext.getErrors()) {
                errors.add(new JsonError(jsonError.getMessage()).path((String)jsonError.getPath().orElse(null)));
            }
            error.embedded((CharSequence)"errors", errors);
        }
        error.link(Link.SELF, Link.of((URI)errorContext.getRequest().getUri()));
        return response.body((Object)error).contentType(MediaType.APPLICATION_JSON_TYPE);
    }
}

