/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.CoroutineHelper;
import io.micronaut.http.server.ExecutableRouteInfo;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.util.KotlinExecutableMethodUtils;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

@Singleton
public final class RouteExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RouteExecutor.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private final Router router;
    private final BeanContext beanContext;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final HttpServerConfiguration serverConfiguration;
    private final ErrorResponseProcessor<?> errorResponseProcessor;
    private final ExecutorSelector executorSelector;
    private final Optional<CoroutineHelper> coroutineHelper;

    public RouteExecutor(Router router, BeanContext beanContext, RequestArgumentSatisfier requestArgumentSatisfier, HttpServerConfiguration serverConfiguration, ErrorResponseProcessor<?> errorResponseProcessor, ExecutorSelector executorSelector) {
        this.router = router;
        this.beanContext = beanContext;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.serverConfiguration = serverConfiguration;
        this.errorResponseProcessor = errorResponseProcessor;
        this.executorSelector = executorSelector;
        this.coroutineHelper = beanContext.findBean(CoroutineHelper.class);
    }

    @NonNull
    public Router getRouter() {
        return this.router;
    }

    @Internal
    @NonNull
    public RequestArgumentSatisfier getRequestArgumentSatisfier() {
        return this.requestArgumentSatisfier;
    }

    @NonNull
    public ErrorResponseProcessor<?> getErrorResponseProcessor() {
        return this.errorResponseProcessor;
    }

    @NonNull
    public ExecutorSelector getExecutorSelector() {
        return this.executorSelector;
    }

    public Optional<CoroutineHelper> getCoroutineHelper() {
        return this.coroutineHelper;
    }

    public Flux<MutableHttpResponse<?>> onError(Throwable t, HttpRequest<?> httpRequest) {
        Class declaringType;
        Throwable cause = (t instanceof CompletionException || t instanceof ExecutionException) && t.getCause() != null ? t.getCause() : t;
        RouteMatch<?> errorRoute = this.findErrorRoute(cause, declaringType = (Class)httpRequest.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).map(RouteInfo::getDeclaringType).orElse(null), httpRequest);
        if (errorRoute != null) {
            if (this.serverConfiguration.isLogHandledExceptions()) {
                this.logException(cause);
            }
            try {
                AtomicReference requestReference = new AtomicReference(httpRequest);
                return this.buildRouteResponsePublisher(requestReference, Flux.just(errorRoute)).doOnNext(response -> response.setAttribute((CharSequence)HttpAttributes.EXCEPTION, (Object)cause)).onErrorResume(throwable -> this.createDefaultErrorResponsePublisher((HttpRequest<?>)((HttpRequest)requestReference.get()), (Throwable)throwable));
            }
            catch (Throwable e) {
                return this.createDefaultErrorResponsePublisher(httpRequest, e).flux();
            }
        }
        Optional optionalDefinition = this.beanContext.findBeanDefinition(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{cause.getClass(), Object.class}));
        if (optionalDefinition.isPresent()) {
            final BeanDefinition handlerDefinition = (BeanDefinition)optionalDefinition.get();
            Optional optionalMethod = handlerDefinition.findPossibleMethods("handle").findFirst();
            Object routeInfo = optionalMethod.isPresent() ? new ExecutableRouteInfo((ExecutableMethod)optionalMethod.get(), true) : new RouteInfo<Object>(){

                public ReturnType<?> getReturnType() {
                    return ReturnType.of(Object.class, (Argument[])new Argument[0]);
                }

                public Class<?> getDeclaringType() {
                    return handlerDefinition.getBeanType();
                }

                public boolean isErrorRoute() {
                    return true;
                }

                public List<MediaType> getProduces() {
                    return MediaType.fromType(this.getDeclaringType()).map(Collections::singletonList).orElse(Collections.emptyList());
                }
            };
            Flux reactiveSequence = Flux.defer(() -> this.lambda$onError$2(handlerDefinition, cause, httpRequest, (RouteInfo)routeInfo));
            ExecutorService executor = this.findExecutor((RouteInfo<?>)routeInfo);
            if (executor != null) {
                reactiveSequence = this.applyExecutorToPublisher((Publisher)reactiveSequence, executor);
            }
            return reactiveSequence.doOnNext(response -> response.setAttribute((CharSequence)HttpAttributes.EXCEPTION, (Object)cause)).onErrorResume(throwable -> this.createDefaultErrorResponsePublisher(httpRequest, (Throwable)throwable));
        }
        if (this.isIgnorable(cause)) {
            this.logIgnoredException(cause);
            return Flux.empty();
        }
        return this.createDefaultErrorResponsePublisher(httpRequest, cause).flux();
    }

    public MutableHttpResponse<?> createDefaultErrorResponse(HttpRequest<?> httpRequest, Throwable cause) {
        this.logException(cause);
        MutableHttpResponse response = HttpResponse.serverError();
        response.setAttribute((CharSequence)HttpAttributes.EXCEPTION, (Object)cause);
        response.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, (Object)new RouteInfo<MutableHttpResponse>(){

            public ReturnType<MutableHttpResponse> getReturnType() {
                return ReturnType.of(MutableHttpResponse.class, (Argument[])new Argument[]{Argument.OBJECT_ARGUMENT});
            }

            public Class<?> getDeclaringType() {
                return Object.class;
            }

            public boolean isErrorRoute() {
                return true;
            }
        });
        MutableHttpResponse<?> mutableHttpResponse = this.errorResponseProcessor.processResponse(ErrorContext.builder(httpRequest).cause(cause).errorMessage("Internal Server Error: " + cause.getMessage()).build(), response);
        this.applyConfiguredHeaders(mutableHttpResponse.getHeaders());
        if (!mutableHttpResponse.getContentType().isPresent()) {
            return mutableHttpResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        return mutableHttpResponse;
    }

    public MediaType resolveDefaultResponseContentType(HttpRequest<?> request, RouteInfo<?> finalRoute) {
        MediaType mt;
        Iterator i;
        List producesList = finalRoute.getProduces();
        if (request != null && (i = request.accept().iterator()).hasNext() && producesList.contains(mt = (MediaType)i.next())) {
            return mt;
        }
        Iterator produces = producesList.iterator();
        MediaType defaultResponseMediaType = produces.hasNext() ? (MediaType)produces.next() : MediaType.APPLICATION_JSON_TYPE;
        return defaultResponseMediaType;
    }

    public Flux<MutableHttpResponse<?>> executeRoute(HttpRequest<?> request, boolean executeFilters, Flux<RouteMatch<?>> routePublisher) {
        AtomicReference requestReference = new AtomicReference(request);
        return this.buildResultEmitter(requestReference, executeFilters, routePublisher);
    }

    public Publisher<MutableHttpResponse<?>> filterPublisher(final AtomicReference<HttpRequest<?>> requestReference, final Publisher<MutableHttpResponse<?>> upstreamResponsePublisher) {
        List httpFilters = this.router.findFilters(requestReference.get());
        if (httpFilters.isEmpty()) {
            return upstreamResponsePublisher;
        }
        final ArrayList filters = new ArrayList(httpFilters);
        final AtomicInteger integer = new AtomicInteger();
        final int len = filters.size();
        final Function<MutableHttpResponse, Publisher> handleStatusException = response -> this.handleStatusException((HttpRequest<?>)((HttpRequest)requestReference.get()), (MutableHttpResponse<?>)response);
        final Function<Throwable, Publisher> onError = t -> this.onError((Throwable)t, (HttpRequest<?>)((HttpRequest)requestReference.get()));
        ServerFilterChain filterChain = new ServerFilterChain(){

            public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                int pos = integer.incrementAndGet();
                if (pos > len) {
                    throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                }
                if (pos == len) {
                    return upstreamResponsePublisher;
                }
                HttpFilter httpFilter = (HttpFilter)filters.get(pos);
                HttpRequest<?> requestForFilter = requestReference.getAndSet(request);
                try {
                    return Flux.from((Publisher)httpFilter.doFilter(requestForFilter, (FilterChain)this)).flatMap(handleStatusException).onErrorResume(onError);
                }
                catch (Throwable t) {
                    return (Publisher)onError.apply(t);
                }
            }
        };
        HttpFilter httpFilter = (HttpFilter)filters.get(0);
        HttpRequest<?> request = requestReference.get();
        try {
            return Flux.from((Publisher)httpFilter.doFilter(request, (FilterChain)filterChain)).flatMap(handleStatusException).onErrorResume(onError);
        }
        catch (Throwable t2) {
            return onError.apply(t2);
        }
    }

    private Mono<MutableHttpResponse<?>> createDefaultErrorResponsePublisher(HttpRequest<?> httpRequest, Throwable cause) {
        return Mono.fromCallable(() -> this.createDefaultErrorResponse(httpRequest, cause));
    }

    private MutableHttpResponse<?> newNotFoundError(HttpRequest<?> request) {
        MutableHttpResponse<?> response = this.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage("Page Not Found").build(), HttpResponse.notFound());
        if (!response.getContentType().isPresent()) {
            return response.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        return response;
    }

    private Mono<MutableHttpResponse<?>> createNotFoundErrorResponsePublisher(HttpRequest<?> httpRequest) {
        return Mono.fromCallable(() -> this.newNotFoundError(httpRequest));
    }

    private void logException(Throwable cause) {
        if (this.isIgnorable(cause)) {
            this.logIgnoredException(cause);
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Unexpected error occurred: " + cause.getMessage(), cause);
        }
    }

    private boolean isIgnorable(Throwable cause) {
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    private void logIgnoredException(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
        }
    }

    private RouteMatch<?> findErrorRoute(Throwable cause, Class<?> declaringType, HttpRequest<?> httpRequest) {
        Optional<Class> rootBeanType;
        RouteMatch errorRoute = null;
        if (cause instanceof BeanCreationException && declaringType != null && (rootBeanType = ((BeanCreationException)cause).getRootBeanType().map(BeanType::getBeanType)).isPresent() && declaringType == rootBeanType.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to instantiate [{}]. Skipping lookup of a local error route", (Object)declaringType.getName());
            }
            declaringType = null;
        }
        if (declaringType != null) {
            errorRoute = this.router.findErrorRoute(declaringType, cause, httpRequest).orElse(null);
        }
        if (errorRoute == null) {
            errorRoute = this.router.findErrorRoute(cause, httpRequest).orElse(null);
        }
        if (errorRoute == null) {
            HttpStatus errorStatus = null;
            if (cause instanceof UnsatisfiedRouteException) {
                errorStatus = HttpStatus.BAD_REQUEST;
            } else if (cause instanceof HttpStatusException) {
                errorStatus = ((HttpStatusException)cause).getStatus();
            }
            if (errorStatus != null) {
                if (declaringType != null) {
                    errorRoute = this.router.findStatusRoute(declaringType, errorStatus, httpRequest).orElse(null);
                }
                if (errorRoute == null) {
                    errorRoute = this.router.findStatusRoute(errorStatus, httpRequest).orElse(null);
                }
            }
        }
        if (errorRoute != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found matching exception handler for exception [{}]: {}", (Object)cause.getMessage(), (Object)errorRoute);
            }
            errorRoute = this.requestArgumentSatisfier.fulfillArgumentRequirements(errorRoute, httpRequest, false);
        }
        return errorRoute;
    }

    private Publisher<MutableHttpResponse<?>> handleStatusException(HttpRequest<?> request, MutableHttpResponse<?> response) {
        RouteMatch<Object> statusRoute;
        HttpStatus status = response.status();
        RouteInfo routeInfo = response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        if (status.getCode() >= 400 && routeInfo != null && !routeInfo.isErrorRoute() && (statusRoute = this.findStatusRoute(request, status, routeInfo)) != null) {
            return this.executeRoute(request, false, Flux.just(statusRoute));
        }
        return Flux.just(response);
    }

    private RouteMatch<Object> findStatusRoute(HttpRequest<?> incomingRequest, HttpStatus status, RouteInfo<?> finalRoute) {
        Class declaringType = finalRoute.getDeclaringType();
        RouteMatch statusRoute = null;
        if (declaringType != null) {
            statusRoute = this.router.findStatusRoute(declaringType, status, incomingRequest).orElseGet(() -> this.router.findStatusRoute(status, incomingRequest).orElse(null));
        }
        return statusRoute;
    }

    private ExecutorService findExecutor(RouteInfo<?> routeMatch) {
        ExecutorService executor = routeMatch instanceof MethodReference ? (ExecutorService)this.executorSelector.select((MethodReference)routeMatch, this.serverConfiguration.getThreadSelection()).orElse(null) : null;
        return executor;
    }

    private <T> Flux<T> applyExecutorToPublisher(Publisher<T> publisher, @Nullable ExecutorService executor) {
        if (executor != null) {
            Scheduler scheduler = Schedulers.fromExecutorService((ExecutorService)executor);
            return Flux.from(publisher).subscribeOn(scheduler).publishOn(scheduler);
        }
        return Flux.from(publisher);
    }

    private boolean isSingle(RouteInfo<?> finalRoute, Class<?> bodyClass) {
        return finalRoute.isSpecifiedSingle() || finalRoute.isSingleResult() && (finalRoute.isAsync() || finalRoute.isSuspended() || Publishers.isSingle(bodyClass));
    }

    private MutableHttpResponse<?> toMutableResponse(HttpResponse<?> message) {
        MutableHttpResponse mutableHttpResponse;
        if (message instanceof MutableHttpResponse) {
            mutableHttpResponse = (MutableHttpResponse)message;
        } else {
            HttpStatus httpStatus = message.status();
            mutableHttpResponse = HttpResponse.status((HttpStatus)httpStatus, (String)httpStatus.getReason());
            mutableHttpResponse.body(message.body());
            message.getHeaders().forEach((name, value) -> {
                for (String val : value) {
                    mutableHttpResponse.header((CharSequence)name, (CharSequence)val);
                }
            });
            mutableHttpResponse.getAttributes().putAll((ConvertibleValues)message.getAttributes());
        }
        return mutableHttpResponse;
    }

    private Mono<MutableHttpResponse<?>> toMutableResponse(HttpRequest<?> request, RouteInfo<?> routeInfo, HttpStatus defaultHttpStatus, Object body) {
        if (body instanceof HttpResponse) {
            MutableHttpResponse<?> outgoingResponse = this.toMutableResponse((HttpResponse)body);
            Argument bodyArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (bodyArgument.isAsyncOrReactive()) {
                return this.processPublisherBody(request, outgoingResponse, routeInfo);
            }
            return Mono.just(outgoingResponse);
        }
        return Mono.just((Object)this.forStatus(routeInfo, defaultHttpStatus).body(body));
    }

    private Flux<MutableHttpResponse<?>> buildRouteResponsePublisher(AtomicReference<HttpRequest<?>> requestReference, Flux<RouteMatch<?>> routeMatchPublisher) {
        return routeMatchPublisher.flatMap(route -> {
            ExecutorService executor = this.findExecutor((RouteInfo<?>)route);
            Flux<MutableHttpResponse<?>> reactiveSequence = this.executeRoute(requestReference, (RouteMatch<?>)route);
            if (executor != null) {
                reactiveSequence = this.applyExecutorToPublisher((Publisher)reactiveSequence, executor);
            }
            return reactiveSequence;
        });
    }

    private Flux<MutableHttpResponse<?>> buildResultEmitter(AtomicReference<HttpRequest<?>> requestReference, boolean executeFilters, Flux<RouteMatch<?>> routeMatchPublisher) {
        Publisher<MutableHttpResponse<?>> executeRoutePublisher = this.buildRouteResponsePublisher(requestReference, routeMatchPublisher).flatMap(response -> this.handleStatusException((HttpRequest<?>)((HttpRequest)requestReference.get()), (MutableHttpResponse<?>)response)).onErrorResume(t -> this.onError((Throwable)t, (HttpRequest<?>)((HttpRequest)requestReference.get())));
        if (executeFilters) {
            executeRoutePublisher = this.filterPublisher(requestReference, executeRoutePublisher);
        }
        return Flux.from((Publisher)executeRoutePublisher);
    }

    private Flux<MutableHttpResponse<?>> executeRoute(AtomicReference<HttpRequest<?>> requestReference, RouteMatch<?> routeMatch) {
        return Flux.deferContextual(contextView -> {
            try {
                HttpRequest httpRequest = (HttpRequest)requestReference.get();
                RouteMatch<?> finalRoute = !routeMatch.isExecutable() ? this.requestArgumentSatisfier.fulfillArgumentRequirements(routeMatch, httpRequest, true) : routeMatch;
                if (finalRoute.isSuspended() && this.coroutineHelper.isPresent()) {
                    this.coroutineHelper.get().setupCoroutineContext((HttpRequest<?>)httpRequest, (ContextView)contextView);
                }
                Object body = ServerRequestContext.with((HttpRequest)httpRequest, () -> finalRoute.execute());
                if (body instanceof Optional) {
                    body = ((Optional)body).orElse(null);
                }
                return this.createResponseForBody((HttpRequest<?>)httpRequest, body, (RouteInfo<?>)finalRoute);
            }
            catch (Throwable e) {
                return Flux.error((Throwable)e);
            }
        });
    }

    private Flux<MutableHttpResponse<?>> createResponseForBody(HttpRequest<?> request, Object body, RouteInfo<?> routeInfo) {
        return Flux.defer(() -> {
            Mono<MutableHttpResponse<?>> outgoingResponse;
            if (body == null) {
                if (routeInfo.isVoid()) {
                    MutableHttpResponse<Object> data = this.forStatus(routeInfo);
                    if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod())) {
                        data.header((CharSequence)"Content-Length", (CharSequence)"0");
                    }
                    outgoingResponse = Mono.just(data);
                } else {
                    outgoingResponse = Mono.just(this.newNotFoundError(request));
                }
            } else {
                boolean isReactive;
                HttpStatus defaultHttpStatus = routeInfo.isErrorRoute() ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.OK;
                boolean bl = isReactive = routeInfo.isAsyncOrReactive() || Publishers.isConvertibleToPublisher((Object)body);
                if (isReactive) {
                    boolean isCompletable;
                    Class<?> bodyClass = body.getClass();
                    boolean isSingle = this.isSingle(routeInfo, bodyClass);
                    boolean bl2 = isCompletable = !isSingle && routeInfo.isVoid() && Publishers.isCompletable(bodyClass);
                    if (isSingle || isCompletable) {
                        Publisher publisher = (Publisher)Publishers.convertPublisher((Object)body, Publisher.class);
                        Supplier<MutableHttpResponse> emptyResponse = () -> {
                            MutableHttpResponse singleResponse = isCompletable || routeInfo.isVoid() ? this.forStatus(routeInfo, HttpStatus.OK).header((CharSequence)"Content-Length", (CharSequence)"0") : this.newNotFoundError(request);
                            return singleResponse;
                        };
                        return Flux.from((Publisher)publisher).flatMap(o -> {
                            Object singleResponse;
                            if (o instanceof Optional) {
                                Optional optional = (Optional)o;
                                if (optional.isPresent()) {
                                    o = ((Optional)o).get();
                                } else {
                                    return Flux.just(emptyResponse.get());
                                }
                            }
                            if (o instanceof HttpResponse) {
                                singleResponse = this.toMutableResponse((HttpResponse)o);
                                Argument bodyArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                if (bodyArgument.isAsyncOrReactive()) {
                                    return this.processPublisherBody(request, (MutableHttpResponse<?>)singleResponse, routeInfo);
                                }
                            } else {
                                singleResponse = o instanceof HttpStatus ? this.forStatus(routeInfo, (HttpStatus)o) : this.forStatus(routeInfo, defaultHttpStatus).body(o);
                            }
                            return Flux.just((Object)singleResponse);
                        }).switchIfEmpty((Publisher)Mono.fromSupplier(emptyResponse));
                    }
                    Argument typeArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                    if (HttpResponse.class.isAssignableFrom(typeArgument.getType())) {
                        Publisher bodyPublisher = (Publisher)Publishers.convertPublisher((Object)body, Publisher.class);
                        Flux response = Flux.from((Publisher)bodyPublisher).map(this::toMutableResponse);
                        Argument bodyArgument = typeArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                        if (bodyArgument.isAsyncOrReactive()) {
                            return response.flatMap(resp -> this.processPublisherBody(request, (MutableHttpResponse<?>)resp, routeInfo));
                        }
                        return response;
                    }
                    MutableHttpResponse response = this.forStatus(routeInfo, defaultHttpStatus).body(body);
                    return this.processPublisherBody(request, response, routeInfo);
                }
                if (body instanceof HttpStatus) {
                    outgoingResponse = Mono.just((Object)HttpResponse.status((HttpStatus)((HttpStatus)body)));
                } else if (routeInfo.isSuspended()) {
                    boolean isKotlinFunctionReturnTypeUnit = routeInfo instanceof MethodBasedRouteMatch && KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit((ExecutableMethod)((MethodBasedRouteMatch)routeInfo).getExecutableMethod());
                    Supplier supplier = ContinuationArgumentBinder.extractContinuationCompletableFutureSupplier((HttpRequest)request);
                    if (KotlinUtils.isKotlinCoroutineSuspended((Object)body)) {
                        return Mono.fromCompletionStage((Supplier)supplier).flatMap(obj -> {
                            MutableHttpResponse response;
                            if (obj instanceof HttpResponse) {
                                response = this.toMutableResponse((HttpResponse)obj);
                                Argument bodyArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                if (bodyArgument.isAsyncOrReactive()) {
                                    return this.processPublisherBody(request, response, routeInfo);
                                }
                            } else {
                                response = this.forStatus(routeInfo, defaultHttpStatus);
                                if (!isKotlinFunctionReturnTypeUnit) {
                                    response = response.body(obj);
                                }
                            }
                            return Mono.just(response);
                        }).switchIfEmpty(this.createNotFoundErrorResponsePublisher(request));
                    }
                    Object suspendedBody = isKotlinFunctionReturnTypeUnit ? Mono.empty() : body;
                    outgoingResponse = this.toMutableResponse(request, routeInfo, defaultHttpStatus, suspendedBody);
                } else {
                    outgoingResponse = this.toMutableResponse(request, routeInfo, defaultHttpStatus, body);
                }
            }
            if (request != null && request.getMethod().equals((Object)HttpMethod.HEAD)) {
                outgoingResponse = outgoingResponse.map(r -> {
                    Object o = r.getBody().orElse(null);
                    if (o instanceof ReferenceCounted) {
                        ((ReferenceCounted)o).release();
                    }
                    r.body(null);
                    return r;
                });
            }
            return outgoingResponse;
        }).doOnNext(response -> {
            this.applyConfiguredHeaders(response.getHeaders());
            if (routeInfo instanceof RouteMatch) {
                response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)routeInfo);
            }
            response.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, (Object)routeInfo);
        });
    }

    private Mono<MutableHttpResponse<?>> processPublisherBody(HttpRequest<?> request, MutableHttpResponse<?> response, RouteInfo<?> routeInfo) {
        Object body = response.body();
        if (body == null) {
            return Mono.just(response);
        }
        if (Publishers.isSingle(body.getClass())) {
            return Mono.from((Publisher)((Publisher)Publishers.convertPublisher((Object)body, Publisher.class))).map(b -> {
                response.body(b);
                return response;
            });
        }
        MediaType mediaType = response.getContentType().orElseGet(() -> this.resolveDefaultResponseContentType(request, routeInfo));
        Flux bodyPublisher = this.applyExecutorToPublisher((Publisher)Publishers.convertPublisher((Object)body, Publisher.class), this.findExecutor(routeInfo));
        return Mono.just((Object)response.header((CharSequence)"Transfer-Encoding", (CharSequence)"chunked").header((CharSequence)"Content-Type", (CharSequence)mediaType).body(bodyPublisher));
    }

    private void applyConfiguredHeaders(MutableHttpHeaders headers) {
        if (this.serverConfiguration.isDateHeader() && !headers.contains("Date")) {
            headers.date(LocalDateTime.now());
        }
        if (!headers.contains("Server")) {
            this.serverConfiguration.getServerHeader().ifPresent(header -> headers.add((CharSequence)"Server", (CharSequence)header));
        }
    }

    private MutableHttpResponse<Object> forStatus(RouteInfo<?> routeMatch) {
        return this.forStatus(routeMatch, HttpStatus.OK);
    }

    private MutableHttpResponse<Object> forStatus(RouteInfo<?> routeMatch, HttpStatus defaultStatus) {
        HttpStatus status = routeMatch.findStatus(defaultStatus);
        return HttpResponse.status((HttpStatus)status);
    }

    private /* synthetic */ Publisher lambda$onError$2(BeanDefinition handlerDefinition, Throwable cause, HttpRequest httpRequest, RouteInfo routeInfo) {
        ExceptionHandler handler = (ExceptionHandler)this.beanContext.getBean(handlerDefinition);
        try {
            if (this.serverConfiguration.isLogHandledExceptions()) {
                this.logException(cause);
            }
            Object result = handler.handle(httpRequest, cause);
            return this.createResponseForBody(httpRequest, result, routeInfo);
        }
        catch (Throwable e) {
            return this.createDefaultErrorResponsePublisher(httpRequest, e);
        }
    }
}

