/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ImmutableArgumentConversionContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import io.micronaut.http.server.cors.CorsUtil;
import io.micronaut.http.server.util.HttpHostResolver;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(value={"/**"})
public class CorsFilter
implements HttpServerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CorsFilter.class);
    private static final ArgumentConversionContext<HttpMethod> CONVERSION_CONTEXT_HTTP_METHOD = ImmutableArgumentConversionContext.of(HttpMethod.class);
    private static final String LOCALHOST = "http://localhost";
    protected final HttpServerConfiguration.CorsConfiguration corsConfiguration;
    @Nullable
    private final HttpHostResolver httpHostResolver;

    @Inject
    public CorsFilter(HttpServerConfiguration.CorsConfiguration corsConfiguration, @Nullable HttpHostResolver httpHostResolver) {
        this.corsConfiguration = corsConfiguration;
        this.httpHostResolver = httpHostResolver;
    }

    @Deprecated
    public CorsFilter(HttpServerConfiguration.CorsConfiguration corsConfiguration) {
        this(corsConfiguration, null);
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        String origin = request.getHeaders().getOrigin().orElse(null);
        if (origin == null) {
            LOG.trace("Http Header Origin not present. Proceeding with the request.");
            return chain.proceed(request);
        }
        CorsOriginConfiguration corsOriginConfiguration = this.getConfiguration(origin).orElse(null);
        if (corsOriginConfiguration != null) {
            if (CorsUtil.isPreflightRequest(request)) {
                return this.handlePreflightRequest(request, chain, corsOriginConfiguration);
            }
            if (!this.validateMethodToMatch(request, corsOriginConfiguration).isPresent()) {
                return CorsFilter.forbidden();
            }
            if (this.shouldDenyToPreventDriveByLocalhostAttack(corsOriginConfiguration, request)) {
                LOG.trace("The resolved configuration allows any origin. To prevent drive-by-localhost attacks the request is forbidden");
                return CorsFilter.forbidden();
            }
            return Publishers.then((Publisher)chain.proceed(request), resp -> this.decorateResponseWithHeaders(request, (MutableHttpResponse<?>)resp, corsOriginConfiguration));
        }
        LOG.trace("CORS configuration not found for {} origin", (Object)origin);
        return chain.proceed(request);
    }

    protected boolean shouldDenyToPreventDriveByLocalhostAttack(@NonNull CorsOriginConfiguration corsOriginConfiguration, @NonNull HttpRequest<?> request) {
        if (this.httpHostResolver == null) {
            return false;
        }
        String host = this.httpHostResolver.resolve(request);
        return this.isAny(corsOriginConfiguration.getAllowedOrigins()) && host.startsWith(LOCALHOST);
    }

    public int getOrder() {
        return ServerFilterPhase.METRICS.after();
    }

    @Deprecated
    protected void handleResponse(HttpRequest<?> request, MutableHttpResponse<?> response) {
    }

    @Deprecated
    protected Optional<MutableHttpResponse<?>> handleRequest(HttpRequest request) {
        return Optional.empty();
    }

    @NonNull
    private Optional<HttpMethod> validateMethodToMatch(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        HttpMethod methodToMatch = this.methodToMatch(request);
        if (!this.methodAllowed(config, methodToMatch)) {
            return Optional.empty();
        }
        return Optional.of(methodToMatch);
    }

    protected void setAllowCredentials(CorsOriginConfiguration config, MutableHttpResponse<?> response) {
        if (config.isAllowCredentials()) {
            response.header((CharSequence)"Access-Control-Allow-Credentials", (CharSequence)Boolean.toString(true));
        }
    }

    protected void setExposeHeaders(List<String> exposedHeaders, MutableHttpResponse<?> response) {
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", exposedHeaders);
            if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
                response.header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)headerValue);
            }
        } else {
            exposedHeaders.forEach(header -> response.header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)header));
        }
    }

    protected void setVary(MutableHttpResponse<?> response) {
        response.header((CharSequence)"Vary", (CharSequence)"Origin");
    }

    protected void setOrigin(@Nullable String origin, @NonNull MutableHttpResponse<?> response) {
        if (origin != null) {
            response.header((CharSequence)"Access-Control-Allow-Origin", (CharSequence)origin);
        }
    }

    protected void setAllowMethods(HttpMethod method, MutableHttpResponse<?> response) {
        response.header((CharSequence)"Access-Control-Allow-Methods", (CharSequence)method);
    }

    protected void setAllowHeaders(List<?> optionalAllowHeaders, MutableHttpResponse<?> response) {
        List allowHeaders = optionalAllowHeaders.stream().map(Object::toString).collect(Collectors.toList());
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", allowHeaders);
            if (StringUtils.isNotEmpty((CharSequence)headerValue)) {
                response.header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)headerValue);
            }
        } else {
            allowHeaders.stream().map(StringUtils::trimLeadingWhitespace).forEach(header -> response.header((CharSequence)"Access-Control-Allow-Headers", (CharSequence)header));
        }
    }

    protected void setMaxAge(long maxAge, MutableHttpResponse<?> response) {
        if (maxAge > -1L) {
            response.header((CharSequence)"Access-Control-Max-Age", (CharSequence)Long.toString(maxAge));
        }
    }

    @NonNull
    private Optional<CorsOriginConfiguration> getConfiguration(@NonNull String requestOrigin) {
        return this.corsConfiguration.getConfigurations().values().stream().filter(config -> {
            List<String> allowedOrigins = config.getAllowedOrigins();
            return !allowedOrigins.isEmpty() && (this.isAny(allowedOrigins) || allowedOrigins.stream().anyMatch(origin -> this.matchesOrigin((String)origin, requestOrigin)));
        }).findFirst();
    }

    private boolean matchesOrigin(@NonNull String origin, @NonNull String requestOrigin) {
        if (origin.equals(requestOrigin)) {
            return true;
        }
        Pattern p = Pattern.compile(origin);
        Matcher m = p.matcher(requestOrigin);
        return m.matches();
    }

    private boolean isAny(List<String> values) {
        return values == CorsOriginConfiguration.ANY;
    }

    private boolean isAnyMethod(List<HttpMethod> allowedMethods) {
        return allowedMethods == CorsOriginConfiguration.ANY_METHOD;
    }

    private boolean methodAllowed(@NonNull CorsOriginConfiguration config, @NonNull HttpMethod methodToMatch) {
        List<HttpMethod> allowedMethods = config.getAllowedMethods();
        return this.isAnyMethod(allowedMethods) || allowedMethods.stream().anyMatch(method -> method.equals((Object)methodToMatch));
    }

    @NonNull
    private HttpMethod methodToMatch(@NonNull HttpRequest<?> request) {
        HttpMethod requestMethod = request.getMethod();
        return CorsUtil.isPreflightRequest(request) ? request.getHeaders().getFirst((CharSequence)"Access-Control-Request-Method", CONVERSION_CONTEXT_HTTP_METHOD).orElse(requestMethod) : requestMethod;
    }

    private boolean hasAllowedHeaders(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        Optional accessControlHeaders = request.getHeaders().get((CharSequence)"Access-Control-Request-Headers", ConversionContext.LIST_OF_STRING);
        List<String> allowedHeaders = config.getAllowedHeaders();
        return this.isAny(allowedHeaders) || accessControlHeaders.isPresent() && ((List)accessControlHeaders.get()).stream().allMatch(header -> allowedHeaders.stream().anyMatch(allowedHeader -> allowedHeader.equalsIgnoreCase(header.trim())));
    }

    @NotNull
    private static Publisher<MutableHttpResponse<?>> forbidden() {
        return Publishers.just((Object)HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN));
    }

    @NonNull
    private void decorateResponseWithHeadersForPreflightRequest(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull CorsOriginConfiguration config) {
        HttpHeaders headers = request.getHeaders();
        headers.getFirst((CharSequence)"Access-Control-Request-Method", CONVERSION_CONTEXT_HTTP_METHOD).ifPresent(methods -> this.setAllowMethods((HttpMethod)methods, response));
        headers.get((CharSequence)"Access-Control-Request-Headers", ConversionContext.LIST_OF_STRING).ifPresent(val -> this.setAllowHeaders((List<?>)val, response));
        this.setMaxAge(config.getMaxAge(), response);
    }

    @NonNull
    private void decorateResponseWithHeaders(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull CorsOriginConfiguration config) {
        HttpHeaders headers = request.getHeaders();
        this.setOrigin(headers.getOrigin().orElse(null), response);
        this.setVary(response);
        this.setExposeHeaders(config.getExposedHeaders(), response);
        this.setAllowCredentials(config, response);
    }

    @NonNull
    private Publisher<MutableHttpResponse<?>> handlePreflightRequest(@NonNull HttpRequest<?> request, @NonNull ServerFilterChain chain, @NonNull CorsOriginConfiguration corsOriginConfiguration) {
        Optional<HttpStatus> statusOptional = this.validatePreflightRequest(request, corsOriginConfiguration);
        if (statusOptional.isPresent()) {
            HttpStatus status = statusOptional.get();
            if (status.getCode() >= 400) {
                return Publishers.just((Object)HttpResponse.status((HttpStatus)status));
            }
            MutableHttpResponse resp2 = HttpResponse.status((HttpStatus)status);
            this.decorateResponseWithHeadersForPreflightRequest(request, resp2, corsOriginConfiguration);
            this.decorateResponseWithHeaders(request, resp2, corsOriginConfiguration);
            return Publishers.just((Object)resp2);
        }
        return Publishers.then((Publisher)chain.proceed(request), resp -> {
            this.decorateResponseWithHeadersForPreflightRequest(request, (MutableHttpResponse<?>)resp, corsOriginConfiguration);
            this.decorateResponseWithHeaders(request, (MutableHttpResponse<?>)resp, corsOriginConfiguration);
        });
    }

    @NonNull
    private Optional<HttpStatus> validatePreflightRequest(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        Optional<HttpMethod> methodToMatchOptional = this.validateMethodToMatch(request, config);
        if (!methodToMatchOptional.isPresent()) {
            return Optional.of(HttpStatus.FORBIDDEN);
        }
        HttpMethod methodToMatch = methodToMatchOptional.get();
        Optional availableHttpMethods = request.getAttribute((CharSequence)HttpAttributes.AVAILABLE_HTTP_METHODS, new ArrayList().getClass());
        if (CorsUtil.isPreflightRequest(request) && availableHttpMethods.isPresent() && ((ArrayList)availableHttpMethods.get()).stream().anyMatch(method -> method.equals((Object)methodToMatch))) {
            if (!this.hasAllowedHeaders(request, config)) {
                return Optional.of(HttpStatus.FORBIDDEN);
            }
            return Optional.of(HttpStatus.OK);
        }
        return Optional.empty();
    }
}

