/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactivePropagation;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.http.server.CoroutineHelper;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.beans.KotlinExecutableMethodUtils;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import io.micronaut.web.router.DefaultRouteInfo;
import io.micronaut.web.router.MethodBasedRouteInfo;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Singleton
public final class RouteExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RouteExecutor.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final Router router;
    final BeanContext beanContext;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final HttpServerConfiguration serverConfiguration;
    final ErrorResponseProcessor<?> errorResponseProcessor;
    private final ExecutorSelector executorSelector;
    private final Optional<CoroutineHelper> coroutineHelper;
    private final ConversionService conversionService;

    public RouteExecutor(Router router, BeanContext beanContext, RequestArgumentSatisfier requestArgumentSatisfier, HttpServerConfiguration serverConfiguration, ErrorResponseProcessor<?> errorResponseProcessor, ExecutorSelector executorSelector) {
        this.router = router;
        this.beanContext = beanContext;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.serverConfiguration = serverConfiguration;
        this.errorResponseProcessor = errorResponseProcessor;
        this.executorSelector = executorSelector;
        this.coroutineHelper = beanContext.findBean(CoroutineHelper.class);
        this.conversionService = beanContext.getConversionService();
    }

    @NonNull
    public Router getRouter() {
        return this.router;
    }

    @Internal
    @NonNull
    public RequestArgumentSatisfier getRequestArgumentSatisfier() {
        return this.requestArgumentSatisfier;
    }

    @NonNull
    public ErrorResponseProcessor<?> getErrorResponseProcessor() {
        return this.errorResponseProcessor;
    }

    @NonNull
    public ExecutorSelector getExecutorSelector() {
        return this.executorSelector;
    }

    public Optional<CoroutineHelper> getCoroutineHelper() {
        return this.coroutineHelper;
    }

    @Nullable
    UriRouteMatch<Object, Object> findRouteMatch(HttpRequest<?> httpRequest) {
        List anyUriRoutes;
        UriRouteMatch routeMatch = this.router.findClosest(httpRequest);
        if (routeMatch == null && httpRequest.getMethod().equals((Object)HttpMethod.OPTIONS) && !(anyUriRoutes = this.router.findAny(httpRequest)).isEmpty()) {
            RouteExecutor.setRouteAttributes(httpRequest, (UriRouteMatch<Object, Object>)((UriRouteMatch)anyUriRoutes.get(0)));
            httpRequest.setAttribute((CharSequence)HttpAttributes.AVAILABLE_HTTP_METHODS, anyUriRoutes.stream().map(UriRouteMatch::getHttpMethod).toList());
        }
        return routeMatch;
    }

    static void setRouteAttributes(HttpRequest<?> request, UriRouteMatch<Object, Object> route) {
        request.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, route);
        request.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, (Object)route.getRouteInfo());
        request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)route.getRouteInfo().getUriMatchTemplate().toString());
    }

    public MutableHttpResponse<?> createDefaultErrorResponse(HttpRequest<?> httpRequest, Throwable cause) {
        this.logException(cause);
        MutableHttpResponse response = HttpResponse.serverError();
        response.setAttribute((CharSequence)HttpAttributes.EXCEPTION, (Object)cause);
        response.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, (Object)new DefaultRouteInfo(ReturnType.of(MutableHttpResponse.class, (Argument[])new Argument[]{Argument.OBJECT_ARGUMENT}), Object.class, true, false));
        MutableHttpResponse<?> mutableHttpResponse = this.errorResponseProcessor.processResponse(ErrorContext.builder(httpRequest).cause(cause).errorMessage("Internal Server Error: " + cause.getMessage()).build(), response);
        this.applyConfiguredHeaders(mutableHttpResponse.getHeaders());
        if (mutableHttpResponse.getContentType().isEmpty() && httpRequest.getMethod() != HttpMethod.HEAD) {
            return mutableHttpResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        return mutableHttpResponse;
    }

    public MediaType resolveDefaultResponseContentType(HttpRequest<?> request, RouteInfo<?> finalRoute) {
        MediaType mt;
        Iterator i;
        List producesList = finalRoute.getProduces();
        if (request != null && (i = request.accept().iterator()).hasNext() && producesList.contains(mt = (MediaType)i.next())) {
            return mt;
        }
        Iterator produces = producesList.iterator();
        MediaType defaultResponseMediaType = produces.hasNext() ? (MediaType)produces.next() : MediaType.APPLICATION_JSON_TYPE;
        return defaultResponseMediaType;
    }

    private MutableHttpResponse<?> newNotFoundError(HttpRequest<?> request) {
        MutableHttpResponse<?> response = this.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage("Page Not Found").build(), HttpResponse.notFound());
        if (response.getContentType().isEmpty() && request.getMethod() != HttpMethod.HEAD) {
            return response.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        return response;
    }

    private Mono<MutableHttpResponse<?>> createNotFoundErrorResponsePublisher(HttpRequest<?> httpRequest) {
        return Mono.fromCallable(() -> this.newNotFoundError(httpRequest));
    }

    void logException(Throwable cause) {
        if (RouteExecutor.isIgnorable(cause)) {
            RouteExecutor.logIgnoredException(cause);
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Unexpected error occurred: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }

    static boolean isIgnorable(Throwable cause) {
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    static void logIgnoredException(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Swallowed an IOException caused by client connectivity: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }

    RouteMatch<?> findErrorRoute(Throwable cause, Class<?> declaringType, HttpRequest<?> httpRequest) {
        RouteMatch errorRoute = null;
        if (cause instanceof BeanCreationException) {
            Optional<Class> rootBeanType;
            BeanCreationException beanCreationException = (BeanCreationException)cause;
            if (declaringType != null && (rootBeanType = beanCreationException.getRootBeanType().map(BeanType::getBeanType)).isPresent() && declaringType == rootBeanType.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to instantiate [{}]. Skipping lookup of a local error route", (Object)declaringType.getName());
                }
                declaringType = null;
            }
        }
        if (declaringType != null) {
            errorRoute = this.router.findErrorRoute(declaringType, cause, httpRequest).orElse(null);
        }
        if (errorRoute == null) {
            errorRoute = this.router.findErrorRoute(cause, httpRequest).orElse(null);
        }
        if (errorRoute == null) {
            HttpStatus errorStatus = null;
            if (cause instanceof UnsatisfiedRouteException || cause instanceof CodecException) {
                errorStatus = HttpStatus.BAD_REQUEST;
            } else if (cause instanceof HttpStatusException) {
                HttpStatusException statusException = (HttpStatusException)cause;
                errorStatus = statusException.getStatus();
            }
            if (errorStatus != null) {
                if (declaringType != null) {
                    errorRoute = this.router.findStatusRoute(declaringType, errorStatus, httpRequest).orElse(null);
                }
                if (errorRoute == null) {
                    errorRoute = this.router.findStatusRoute(errorStatus, httpRequest).orElse(null);
                }
            }
        }
        if (errorRoute != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found matching exception handler for exception [{}]: {}", (Object)cause.getMessage(), (Object)errorRoute);
            }
            this.requestArgumentSatisfier.fulfillArgumentRequirementsBeforeFilters(errorRoute, httpRequest);
        }
        return errorRoute;
    }

    RouteMatch<Object> findStatusRoute(HttpRequest<?> incomingRequest, int status, RouteInfo<?> finalRoute) {
        Class declaringType = finalRoute.getDeclaringType();
        RouteMatch statusRoute = null;
        if (declaringType != null) {
            statusRoute = this.router.findStatusRoute(declaringType, status, incomingRequest).orElseGet(() -> this.router.findStatusRoute(status, incomingRequest).orElse(null));
        }
        return statusRoute;
    }

    ExecutorService findExecutor(RouteInfo<?> routeInfo) {
        ExecutorService executor;
        if (routeInfo instanceof MethodReference) {
            MethodReference methodReference = (MethodReference)routeInfo;
            executor = this.executorSelector.select(methodReference, this.serverConfiguration.getThreadSelection()).orElse(null);
        } else if (routeInfo instanceof MethodBasedRouteInfo) {
            MethodBasedRouteInfo methodBasedRouteInfo = (MethodBasedRouteInfo)routeInfo;
            executor = this.executorSelector.select((MethodReference)methodBasedRouteInfo.getTargetMethod().getExecutableMethod(), this.serverConfiguration.getThreadSelection()).orElse(null);
        } else {
            executor = null;
        }
        return executor;
    }

    private <T> Flux<T> applyExecutorToPublisher(Publisher<T> publisher, @Nullable ExecutorService executor, final PropagatedContext propagatedContext) {
        if (executor == null) {
            return Flux.from(publisher).subscribeOn(Schedulers.fromExecutor(command -> propagatedContext.wrap(command).run()));
        }
        if (executor instanceof InstrumentedExecutorService) {
            InstrumentedExecutorService instrumentedExecutorService = (InstrumentedExecutorService)executor;
            executor = instrumentedExecutorService.getTarget();
        }
        if (executor instanceof ScheduledExecutorService) {
            final ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor;
            executor = new InstrumentedScheduledExecutorService(){

                public ScheduledExecutorService getTarget() {
                    return scheduledExecutorService;
                }

                public <X> Callable<X> instrument(Callable<X> task) {
                    return propagatedContext.wrap(task);
                }

                public Runnable instrument(Runnable command) {
                    return propagatedContext.wrap(command);
                }
            };
        } else {
            final ExecutorService finalExecutor = executor;
            executor = new InstrumentedExecutorService(){

                public ExecutorService getTarget() {
                    return finalExecutor;
                }

                public <X> Callable<X> instrument(Callable<X> task) {
                    return propagatedContext.wrap(task);
                }

                public Runnable instrument(Runnable command) {
                    return propagatedContext.wrap(command);
                }
            };
        }
        Scheduler scheduler = Schedulers.fromExecutorService((ExecutorService)executor);
        return Flux.from(publisher).subscribeOn(scheduler).publishOn(scheduler);
    }

    private boolean isSingle(RouteInfo<?> finalRoute, Class<?> bodyClass) {
        return finalRoute.isSpecifiedSingle() || finalRoute.isSingleResult() && (finalRoute.isAsync() || finalRoute.isSuspended() || Publishers.isSingle(bodyClass));
    }

    private ExecutionFlow<MutableHttpResponse<?>> fromImperativeExecute(PropagatedContext propagatedContext, HttpRequest<?> request, RouteInfo<?> routeInfo, Object body) {
        if (body instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)body;
            MutableHttpResponse outgoingResponse = httpResponse.toMutableResponse();
            Argument bodyArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (bodyArgument.isAsyncOrReactive()) {
                return RouteExecutor.fromPublisher(this.processPublisherBody(propagatedContext, request, outgoingResponse, routeInfo));
            }
            return ExecutionFlow.just((Object)outgoingResponse);
        }
        return ExecutionFlow.just((Object)this.forStatus(routeInfo, null).body(body));
    }

    ExecutionFlow<MutableHttpResponse<?>> callRoute(PropagatedContext propagatedContext, RouteMatch<?> routeMatch, HttpRequest<?> request) {
        RouteInfo routeInfo = routeMatch.getRouteInfo();
        ExecutorService executorService = routeInfo.getExecutor(this.serverConfiguration.getThreadSelection());
        Object executeMethodResponseFlow = executorService != null ? (routeInfo.isSuspended() ? ReactiveExecutionFlow.fromPublisher((Publisher)Mono.deferContextual(contextView -> {
            this.coroutineHelper.ifPresent(helper -> helper.setupCoroutineContext(request, (ContextView)contextView, propagatedContext));
            return Mono.from((Publisher)ReactiveExecutionFlow.fromFlow(this.executeRouteAndConvertBody(propagatedContext, routeMatch, request)).toPublisher());
        })) : (routeInfo.isReactive() ? ReactiveExecutionFlow.async((Executor)executorService, () -> this.executeRouteAndConvertBody(propagatedContext, routeMatch, request)) : ExecutionFlow.async((Executor)executorService, () -> this.executeRouteAndConvertBody(propagatedContext, routeMatch, request)))) : (routeInfo.isSuspended() ? ReactiveExecutionFlow.fromPublisher((Publisher)Mono.deferContextual(contextView -> {
            this.coroutineHelper.ifPresent(helper -> helper.setupCoroutineContext(request, (ContextView)contextView, propagatedContext));
            return Mono.from((Publisher)ReactiveExecutionFlow.fromFlow(this.executeRouteAndConvertBody(propagatedContext, routeMatch, request)).toPublisher());
        })) : (routeInfo.isReactive() ? ReactiveExecutionFlow.fromFlow(this.executeRouteAndConvertBody(propagatedContext, routeMatch, request)) : this.executeRouteAndConvertBody(propagatedContext, routeMatch, request)));
        return executeMethodResponseFlow;
    }

    private ExecutionFlow<MutableHttpResponse<?>> executeRouteAndConvertBody(PropagatedContext propagatedContext, RouteMatch<?> routeMatch, HttpRequest<?> httpRequest) {
        ExecutionFlow<MutableHttpResponse<?>> executionFlow;
        block9: {
            PropagatedContext.Scope ignore = propagatedContext.propagate();
            try {
                this.requestArgumentSatisfier.fulfillArgumentRequirementsAfterFilters(routeMatch, httpRequest);
                Object body = ServerRequestContext.with(httpRequest, () -> routeMatch.execute());
                if (body instanceof Optional) {
                    Optional optional = (Optional)body;
                    body = optional.orElse(null);
                }
                executionFlow = this.createResponseForBody(propagatedContext, httpRequest, body, routeMatch.getRouteInfo(), routeMatch);
                if (ignore == null) break block9;
            }
            catch (Throwable e) {
                try {
                    ExecutionFlow executionFlow2 = ExecutionFlow.error((Throwable)e);
                    return executionFlow2;
                }
                finally {
                    if (ignore != null) {
                        ignore.close();
                    }
                }
            }
            ignore.close();
        }
        return executionFlow;
    }

    ExecutionFlow<MutableHttpResponse<?>> createResponseForBody(PropagatedContext propagatedContext, HttpRequest<?> request, Object body, RouteInfo<?> routeInfo, @Nullable RouteMatch<?> routeMatch) {
        ExecutionFlow<MutableHttpResponse<?>> outgoingResponse;
        if (body == null) {
            if (routeInfo.isVoid()) {
                MutableHttpResponse<Object> data = this.forStatus(routeInfo);
                if (request.getMethod().permitsRequestBody()) {
                    data.header((CharSequence)"Content-Length", (CharSequence)"0");
                }
                outgoingResponse = ExecutionFlow.just(data);
            } else {
                outgoingResponse = ExecutionFlow.just(this.newNotFoundError(request));
            }
        } else {
            boolean isReactive;
            boolean bl = isReactive = routeInfo.isAsyncOrReactive() || Publishers.isConvertibleToPublisher((Object)body) && !(body instanceof HttpResponse);
            if (isReactive) {
                outgoingResponse = ReactiveExecutionFlow.fromPublisher((Publisher)ReactivePropagation.propagate((PropagatedContext)propagatedContext, this.fromReactiveExecute(propagatedContext, request, body, routeInfo)));
            } else if (body instanceof HttpStatus) {
                HttpStatus httpStatus = (HttpStatus)body;
                outgoingResponse = ExecutionFlow.just((Object)HttpResponse.status((HttpStatus)httpStatus));
            } else {
                outgoingResponse = routeInfo.isSuspended() ? this.fromKotlinCoroutineExecute(propagatedContext, request, body, routeInfo) : this.fromImperativeExecute(propagatedContext, request, routeInfo, body);
            }
        }
        outgoingResponse = outgoingResponse.map(response -> {
            if (request != null && request.getMethod().equals((Object)HttpMethod.HEAD)) {
                Object o = response.getBody().orElse(null);
                if (o instanceof ReferenceCounted) {
                    ReferenceCounted referenceCounted = o;
                    referenceCounted.release();
                }
                response.body(null);
            }
            this.applyConfiguredHeaders(response.getHeaders());
            if (routeMatch != null) {
                response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)routeMatch);
            }
            response.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, (Object)routeInfo);
            response.bodyWriter(routeInfo.getMessageBodyWriter());
            return response;
        });
        return outgoingResponse;
    }

    private ExecutionFlow<MutableHttpResponse<?>> fromKotlinCoroutineExecute(PropagatedContext propagatedContext, HttpRequest<?> request, Object body, RouteInfo<?> routeInfo) {
        MethodBasedRouteMatch methodBasedRouteMatch;
        boolean isKotlinFunctionReturnTypeUnit = routeInfo instanceof MethodBasedRouteMatch && KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit((ExecutableMethod)(methodBasedRouteMatch = (MethodBasedRouteMatch)routeInfo).getExecutableMethod());
        Supplier supplier = ContinuationArgumentBinder.extractContinuationCompletableFutureSupplier(request);
        if (KotlinUtils.isKotlinCoroutineSuspended((Object)body)) {
            return ReactiveExecutionFlow.fromPublisher((Publisher)Mono.fromCompletionStage((Supplier)supplier).flatMap(obj -> {
                MutableHttpResponse response;
                if (obj instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)obj;
                    response = httpResponse.toMutableResponse();
                    Argument bodyArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                    if (bodyArgument.isAsyncOrReactive()) {
                        return this.processPublisherBody(propagatedContext, request, response, routeInfo);
                    }
                } else {
                    response = this.forStatus(routeInfo, null);
                    if (!isKotlinFunctionReturnTypeUnit) {
                        response = response.body(obj);
                    }
                }
                return Mono.just((Object)response);
            }).switchIfEmpty(this.createNotFoundErrorResponsePublisher(request)));
        }
        Object suspendedBody = isKotlinFunctionReturnTypeUnit ? Mono.empty() : body;
        return this.fromImperativeExecute(propagatedContext, request, routeInfo, suspendedBody);
    }

    private CorePublisher<MutableHttpResponse<?>> fromReactiveExecute(PropagatedContext propagatedContext, HttpRequest<?> request, Object body, RouteInfo<?> routeInfo) {
        boolean isCompletable;
        Class<?> bodyClass = body.getClass();
        boolean isSingle = this.isSingle(routeInfo, bodyClass);
        boolean bl = isCompletable = !isSingle && routeInfo.isVoid() && Publishers.isCompletable(bodyClass);
        if (isSingle || isCompletable) {
            Publisher publisher = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)body, Publisher.class);
            Supplier<MutableHttpResponse> emptyResponse = () -> {
                MutableHttpResponse singleResponse = isCompletable || routeInfo.isVoid() ? this.forStatus(routeInfo, HttpStatus.OK).header((CharSequence)"Content-Length", (CharSequence)"0") : this.newNotFoundError(request);
                return singleResponse;
            };
            return Flux.from((Publisher)publisher).flatMap(o -> {
                MutableHttpResponse<Object> singleResponse;
                if (o instanceof Optional) {
                    Optional optional = (Optional)o;
                    if (optional.isPresent()) {
                        o = optional.get();
                    } else {
                        return Flux.just((Object)((MutableHttpResponse)emptyResponse.get()));
                    }
                }
                if (o instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)o;
                    singleResponse = httpResponse.toMutableResponse();
                    Argument bodyArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                    if (bodyArgument.isAsyncOrReactive()) {
                        return this.processPublisherBody(propagatedContext, request, singleResponse, routeInfo);
                    }
                } else if (o instanceof HttpStatus) {
                    HttpStatus status = (HttpStatus)o;
                    singleResponse = this.forStatus(routeInfo, status);
                } else {
                    singleResponse = this.forStatus(routeInfo, null).body(o);
                }
                return Flux.just(singleResponse);
            }).switchIfEmpty((Publisher)Mono.fromSupplier(emptyResponse)).contextWrite(context -> ReactorPropagation.addPropagatedContext((Context)context, (PropagatedContext)propagatedContext).put((Object)"micronaut.http.server.request", (Object)request));
        }
        Argument typeArgument = routeInfo.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        if (HttpResponse.class.isAssignableFrom(typeArgument.getType())) {
            Publisher bodyPublisher = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)body, Publisher.class);
            Flux response = Flux.from((Publisher)bodyPublisher).map(HttpResponse::toMutableResponse);
            Argument bodyArgument = typeArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (bodyArgument.isAsyncOrReactive()) {
                return response.flatMap(resp -> this.processPublisherBody(propagatedContext, request, (MutableHttpResponse<?>)resp, routeInfo));
            }
            return response.contextWrite(context -> ReactorPropagation.addPropagatedContext((Context)context, (PropagatedContext)propagatedContext).put((Object)"micronaut.http.server.request", (Object)request));
        }
        MutableHttpResponse response = this.forStatus(routeInfo, null).body(body);
        return this.processPublisherBody(propagatedContext, request, response, routeInfo);
    }

    private Mono<MutableHttpResponse<?>> processPublisherBody(PropagatedContext propagatedContext, HttpRequest<?> request, MutableHttpResponse<?> response, RouteInfo<?> routeInfo) {
        Object body = response.body();
        if (body == null) {
            return Mono.just(response);
        }
        if (Publishers.isSingle(body.getClass())) {
            return Mono.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)body, Publisher.class))).map(b -> {
                response.body(b);
                return response;
            });
        }
        MediaType mediaType = response.getContentType().orElseGet(() -> this.resolveDefaultResponseContentType(request, routeInfo));
        Flux bodyPublisher = this.applyExecutorToPublisher((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)body, Publisher.class), this.findExecutor(routeInfo), propagatedContext).contextWrite(cv -> ReactorPropagation.addPropagatedContext((Context)cv, (PropagatedContext)propagatedContext).put((Object)"micronaut.http.server.request", (Object)request));
        return Mono.just((Object)response.header((CharSequence)"Transfer-Encoding", (CharSequence)"chunked").header((CharSequence)"Content-Type", (CharSequence)mediaType).body((Object)ReactivePropagation.propagate((PropagatedContext)propagatedContext, (Publisher)bodyPublisher))).contextWrite(context -> ReactorPropagation.addPropagatedContext((Context)context, (PropagatedContext)propagatedContext).put((Object)"micronaut.http.server.request", (Object)request));
    }

    private void applyConfiguredHeaders(MutableHttpHeaders headers) {
        if (this.serverConfiguration.isDateHeader() && !headers.contains("Date")) {
            headers.date(LocalDateTime.now());
        }
        if (headers.get((CharSequence)"Server") == null) {
            this.serverConfiguration.getServerHeader().ifPresent(header -> headers.add((CharSequence)"Server", (CharSequence)header));
        }
    }

    private MutableHttpResponse<Object> forStatus(RouteInfo<?> routeMatch) {
        return this.forStatus(routeMatch, HttpStatus.OK);
    }

    private MutableHttpResponse<Object> forStatus(RouteInfo<?> routeMatch, HttpStatus defaultStatus) {
        HttpStatus status = routeMatch.findStatus(defaultStatus);
        return HttpResponse.status((HttpStatus)status);
    }

    static <K> ExecutionFlow<K> fromPublisher(Publisher<K> publisher) {
        return ReactiveExecutionFlow.fromPublisher(publisher);
    }
}

