/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.LocaleResolver;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.HtmlErrorResponseBodyProvider;
import io.micronaut.http.util.HtmlSanitizer;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
@Singleton
@Requires(missingBeans={HtmlErrorResponseBodyProvider.class})
final class DefaultHtmlErrorResponseBodyProvider
implements HtmlErrorResponseBodyProvider {
    private static final Map<Integer, String> DEFAULT_ERROR_BOLD = Map.of(HttpStatus.NOT_FOUND.getCode(), "The page you were looking for doesn\u2019t exist", HttpStatus.REQUEST_ENTITY_TOO_LARGE.getCode(), "The file or data you are trying to upload exceeds the allowed size");
    private static final Map<Integer, String> DEFAULT_ERROR = Map.of(HttpStatus.NOT_FOUND.getCode(), "You may have mistyped the address or the page may have moved", HttpStatus.REQUEST_ENTITY_TOO_LARGE.getCode(), "Please try again with a smaller file");
    private static final String CSS = "                      *, *::before, *::after {\n                        box-sizing: border-box;\n                      }\n                      * {\n                        margin: 0;\n                      }\n                      html {\n                        font-size: 16px;\n                      }\n                      h2 {\n                          margin-top: -0.95em;\n                          font-size: 6em;\n                          opacity: .2;\n                      }\n                      body {\n                        background: #2559a7;\n                        color: #FFF;\n                        display: grid;\n                        font-family: -apple-system, \"Helvetica Neue\", Helvetica, sans-serif;\n                        font-size: clamp(1rem, 2.5vw, 2rem);\n                        -webkit-font-smoothing: antialiased;\n                        font-style: normal;\n                        font-weight: 400;\n                        letter-spacing: -0.0025em;\n                        line-height: 1.4;\n                        min-height: 100vh;\n                        place-items: center;\n                        text-rendering: optimizeLegibility;\n                        -webkit-text-size-adjust: 100%;\n                      }\n                      a {\n                        color: inherit;\n                        font-weight: 700;\n                        text-decoration: underline;\n                        text-underline-offset: 0.0925em;\n                      }\n                      b, strong {\n                        font-weight: 700;\n                      }\n                      i, em {\n                        font-style: italic;\n                      }\n                      main {\n                        display: grid;\n                        gap: 1em;\n                        padding: 2em;\n                        place-items: center;\n                        text-align: center;\n                      }\n                      main header {\n                        width: min(100%, 18em);\n                      }\n                      main header svg {\n                        height: auto;\n                        max-width: 100%;\n                        width: 100%;\n                      }\n                      main article {\n                        margin-top: -0.95em;\n                        width: min(100%, 30em);\n                      }\n                      main article p {\n                        font-size: 75%;\n                      }\n                      main article br {\n                        display: none;\n                        @media(min-width: 48em) {\n                          display: inline;\n                        }\n                      }\n";
    private final HtmlSanitizer htmlSanitizer;
    private final MessageSource messageSource;
    private final LocaleResolver<HttpRequest<?>> localeResolver;
    private final Map<LocaleStatus, String> cache = new ConcurrentHashMap<LocaleStatus, String>();

    DefaultHtmlErrorResponseBodyProvider(HtmlSanitizer htmlSanitizer, MessageSource messageSource, LocaleResolver<HttpRequest<?>> localeResolver) {
        this.htmlSanitizer = htmlSanitizer;
        this.messageSource = messageSource;
        this.localeResolver = localeResolver;
    }

    @Override
    public String body(@NonNull ErrorContext errorContext, @NonNull HttpResponse<?> response) {
        int httpStatusCode = response.code();
        String httpStatusReason = this.htmlSanitizer.sanitize(response.reason());
        Locale locale = this.localeResolver.resolveOrDefault(errorContext.getRequest());
        return this.cache.computeIfAbsent(new LocaleStatus(locale, httpStatusCode), key -> this.html(locale, httpStatusCode, httpStatusReason, errorContext));
    }

    private String html(Locale locale, int httpStatusCode, String httpStatusReason, ErrorContext errorContext) {
        String errorTitleCode = httpStatusCode + ".error.title";
        String errorTitle = this.messageSource.getMessage(errorTitleCode, httpStatusReason, locale);
        String header = "<h1>" + errorTitle + "</h1>";
        header = header + "<h2>" + httpStatusCode + "</h1>";
        return MessageFormat.format("<!doctype html><html lang=\"en\"><head><title>{0} \u2014 {1}</title><meta charset=\"utf-8\"><meta name=\"viewport\" content=\"initial-scale=1, width=device-width\"><meta name=\"robots\" content=\"noindex, nofollow\"><style>{2}</style></head><body><main><header>{3}</header><article>{4}</article></main></body></html>", httpStatusCode, errorTitle, CSS, header, this.article(locale, httpStatusCode, httpStatusReason, errorContext));
    }

    private String article(Locale locale, int httpStatusCode, String httpStatusReason, ErrorContext errorContext) {
        String errorBoldCode = httpStatusCode + ".error.bold";
        String errorCode = httpStatusCode + ".error";
        String defaultErrorBold = DEFAULT_ERROR_BOLD.get(httpStatusCode);
        String defaultError = DEFAULT_ERROR.get(httpStatusCode);
        String errorBold = defaultErrorBold != null ? this.messageSource.getMessage(errorBoldCode, defaultErrorBold, locale) : (String)this.messageSource.getMessage(errorBoldCode, locale).orElse(null);
        String error = defaultError != null ? this.messageSource.getMessage(errorCode, defaultError, locale) : (String)this.messageSource.getMessage(errorCode, locale).orElse(null);
        StringBuilder sb = new StringBuilder();
        for (Error e : errorContext.getErrors()) {
            if (e.getMessage().equalsIgnoreCase(httpStatusReason)) continue;
            sb.append(this.htmlSanitizer.sanitize(e.getMessage()));
            sb.append("<br/>");
        }
        if (error != null || errorBold != null) {
            sb.append("<p>");
            if (errorBold != null) {
                sb.append("<strong>");
                sb.append(errorBold);
                sb.append("</strong>. ");
            }
            if (error != null) {
                sb.append(error);
                sb.append(".");
            }
            sb.append("</p>");
        }
        return sb.toString();
    }

    private record LocaleStatus(Locale locale, int httpStatusCode) {
    }
}

