/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.body.AbstractFileBodyWriter;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@Internal
@Singleton
public final class InputStreamBodyWriter
extends AbstractFileBodyWriter
implements ResponseBodyWriter<InputStream> {
    private final ExecutorService executorService;

    InputStreamBodyWriter(HttpServerConfiguration.FileTypeHandlerConfiguration configuration, @Named(value="blocking") ExecutorService executorService) {
        super(configuration);
        this.executorService = executorService;
    }

    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<InputStream> type, @NonNull MediaType mediaType, InputStream object) {
        return InputStreamByteBody.create((InputStream)object, (OptionalLong)OptionalLong.empty(), (Executor)this.executorService, (ByteBodyFactory)bodyFactory);
    }

    public void writeTo(Argument<InputStream> type, MediaType mediaType, InputStream object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException("Can only be used in a Netty context");
    }
}

