/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.runtime.server.EmbeddedServer;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class EmbeddedServerUnderTest
implements ServerUnderTest {
    private final boolean isBlockingClient;
    private final EmbeddedServer embeddedServer;
    private HttpClient httpClient;
    private BlockingHttpClient client;

    public EmbeddedServerUnderTest(@NonNull Map<String, Object> properties) {
        this.embeddedServer = (EmbeddedServer)ApplicationContext.run(EmbeddedServer.class, properties, (String[])new String[0]);
        this.isBlockingClient = (Boolean)properties.getOrDefault("use.blocking.client", true);
    }

    @Override
    public <I, O> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType) {
        if (this.isBlockingClient) {
            return this.getBlockingHttpClient().exchange(request, bodyType);
        }
        return (HttpResponse)Flux.from((Publisher)this.getHttpClient().exchange(request, bodyType)).blockFirst();
    }

    @Override
    public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        if (this.isBlockingClient) {
            return this.getBlockingHttpClient().exchange(request, bodyType, errorType);
        }
        return (HttpResponse)Flux.from((Publisher)this.getHttpClient().exchange(request, bodyType, errorType)).blockFirst();
    }

    public ApplicationContext getApplicationContext() {
        return this.embeddedServer.getApplicationContext();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.embeddedServer != null) {
            this.embeddedServer.getApplicationContext().close();
            this.embeddedServer.close();
        }
    }

    @Override
    @NonNull
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.embeddedServer).map(EmbeddedServer::getPort);
    }

    @Override
    @NonNull
    public Optional<URL> getURL() {
        return Optional.ofNullable(this.embeddedServer).map(EmbeddedServer::getURL);
    }

    @NonNull
    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = (HttpClient)this.getApplicationContext().createBean(HttpClient.class, new Object[]{this.embeddedServer.getURL()});
        }
        return this.httpClient;
    }

    @NonNull
    private BlockingHttpClient getBlockingHttpClient() {
        if (this.client == null) {
            this.client = this.getHttpClient().toBlocking();
        }
        return this.client;
    }
}

