/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.tck.BodyAssertion;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class HttpResponseAssertion {
    private final HttpStatus httpStatus;
    private final Map<String, String> headers;
    private final BodyAssertion<?, ?> bodyAssertion;
    @Nullable
    private final Consumer<HttpResponse<?>> responseConsumer;

    private HttpResponseAssertion(HttpStatus httpStatus, Map<String, String> headers, BodyAssertion<?, ?> bodyAssertion, @Nullable Consumer<HttpResponse<?>> responseConsumer) {
        this.httpStatus = httpStatus;
        this.headers = headers;
        this.bodyAssertion = bodyAssertion;
        this.responseConsumer = responseConsumer;
    }

    @NonNull
    public Optional<Consumer<HttpResponse<?>>> getResponseConsumer() {
        return Optional.ofNullable(this.responseConsumer);
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public BodyAssertion<?, ?> getBody() {
        return this.bodyAssertion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpStatus httpStatus;
        private Map<String, String> headers;
        private BodyAssertion<?, ?> bodyAssertion;
        private Consumer<HttpResponse<?>> responseConsumer;

        public Builder assertResponse(Consumer<HttpResponse<?>> responseConsumer) {
            this.responseConsumer = responseConsumer;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder header(String headerName, String headerValue) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(headerName, headerValue);
            return this;
        }

        public Builder body(String containsBody) {
            this.bodyAssertion = BodyAssertion.builder().body(containsBody).contains();
            return this;
        }

        public Builder body(BodyAssertion<?, ?> bodyAssertion) {
            this.bodyAssertion = bodyAssertion;
            return this;
        }

        public Builder status(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public HttpResponseAssertion build() {
            return new HttpResponseAssertion(Objects.requireNonNull(this.httpStatus), this.headers, this.bodyAssertion, this.responseConsumer);
        }
    }
}

